/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DynamicBuffer {
    protected static final int DEFAULT_BUFFER_SIZE = 32768;
    protected byte[] buf;
    protected int writepos = 0;
    protected int readpos = 0;
    private Object lock = new Object();
    protected InputStream in;
    protected OutputStream out;

    public DynamicBuffer() {
        this.buf = new byte[32768];
        this.in = new DynamicBufferInputStream();
        this.out = new DynamicBufferOutputStream();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void verifyBufferSize(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.buf.length - this.writepos) {
                System.arraycopy(this.buf, this.readpos, this.buf, 0, this.writepos - this.readpos);
                this.writepos -= this.readpos;
                this.readpos = 0;
            }
            if (n > this.buf.length - this.writepos) {
                byte[] byArray = new byte[this.buf.length + 32768];
                System.arraycopy(this.buf, 0, byArray, 0, this.writepos - this.readpos);
                this.buf = byArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int available() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.writepos - this.readpos;
            return n;
        }
    }

    private synchronized void block() {
        while (this.readpos >= this.writepos) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.verifyBufferSize(1);
            this.buf[this.writepos] = (byte)n;
            ++this.writepos;
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyBufferSize(n2);
            System.arraycopy(byArray, n, this.buf, this.writepos, n2);
            this.writepos += n2;
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read() throws IOException {
        this.block();
        Object object = this.lock;
        synchronized (object) {
            byte by = this.buf[this.readpos++];
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.block();
        Object object = this.lock;
        synchronized (object) {
            int n3 = n2 > this.writepos - this.readpos ? this.writepos - this.readpos : n2;
            System.arraycopy(this.buf, this.readpos, byArray, n, n3);
            this.readpos += n3;
            int n4 = n3;
            return n4;
        }
    }

    public synchronized void flush() throws IOException {
        this.notifyAll();
    }

    class DynamicBufferOutputStream
    extends OutputStream {
        DynamicBufferOutputStream() {
        }

        public void write(int n) {
            DynamicBuffer.this.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            DynamicBuffer.this.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            DynamicBuffer.this.flush();
        }
    }

    class DynamicBufferInputStream
    extends InputStream {
        DynamicBufferInputStream() {
        }

        public int read() throws IOException {
            return DynamicBuffer.this.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return DynamicBuffer.this.read(byArray, n, n2);
        }

        public int available() {
            return DynamicBuffer.this.available();
        }
    }
}

