/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient {
    SftpSubsystemClient sftp;
    String cwd;
    String lcwd;

    SftpClient(SshClient sshClient) throws IOException {
        this(sshClient, null);
    }

    SftpClient(SshClient sshClient, ChannelEventListener channelEventListener) throws IOException {
        if (!sshClient.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.sftp = sshClient.openSftpChannel(channelEventListener);
        this.cwd = this.sftp.getDefaultDirectory();
        this.lcwd = System.getProperty("user.home");
    }

    public void cd(String string) throws IOException {
        try {
            String string2 = this.resolveRemotePath(string);
            string2 = this.sftp.getAbsolutePath(string2);
            FileAttributes fileAttributes = this.sftp.getAttributes(string2);
            if (!fileAttributes.isDirectory()) {
                throw new IOException(string + " is not a directory");
            }
            this.cwd = string2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " could not be found");
        }
    }

    private File resolveLocalPath(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.lcwd, string);
        }
        return file;
    }

    private String resolveRemotePath(String string) throws IOException {
        this.verifyConnection();
        String string2 = !string.startsWith("/") ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + string : string;
        return string2;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public void mkdir(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        this.sftp.makeDirectory(string2);
    }

    public void mkdirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = string.startsWith("/") ? "/" : "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + (String)stringTokenizer.nextElement();
            try {
                this.stat(string2);
            }
            catch (IOException iOException) {
                try {
                    this.mkdir(string2);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            string2 = string2 + "/";
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public List ls() throws IOException {
        return this.ls(this.cwd);
    }

    public List ls(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (!fileAttributes.isDirectory()) {
            throw new IOException(string + " is not a directory");
        }
        SftpFile sftpFile = this.sftp.openDirectory(string2);
        Vector vector = new Vector();
        while (this.sftp.listChildren(sftpFile, vector) > -1) {
        }
        sftpFile.close();
        return vector;
    }

    public void lcd(String string) throws IOException {
        File file = !SftpClient.isLocalAbsolutePath(string) ? new File(this.lcwd, string) : new File(string);
        if (!file.isDirectory()) {
            throw new IOException(string + " is not a directory");
        }
        this.lcwd = file.getCanonicalPath();
    }

    private static boolean isLocalAbsolutePath(String string) {
        return new File(string).isAbsolute();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public void get(String string) throws IOException {
        this.get(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) > -1) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public void get(String string, String string2) throws IOException {
        File file = this.resolveLocalPath(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.get(string, fileOutputStream);
    }

    public void get(String string, OutputStream outputStream) throws IOException {
        String string2 = this.resolveRemotePath(string);
        SftpFileInputStream sftpFileInputStream = new SftpFileInputStream(this.sftp.openFile(string2, 1));
        this.transferFile(sftpFileInputStream, outputStream);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String string) throws IOException {
        this.put(string, string);
    }

    public void put(String string, String string2) throws IOException {
        File file = this.resolveLocalPath(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.put(fileInputStream, string2);
    }

    public void put(InputStream inputStream, String string) throws IOException {
        SftpFileOutputStream sftpFileOutputStream;
        String string2 = this.resolveRemotePath(string);
        try {
            FileAttributes fileAttributes = this.stat(string2);
            sftpFileOutputStream = new SftpFileOutputStream(this.sftp.openFile(string2, 26));
        }
        catch (IOException iOException) {
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setPermissions(new UnsignedInteger32(511L));
            sftpFileOutputStream = new SftpFileOutputStream(this.sftp.openFile(string2, 10, fileAttributes));
        }
        this.transferFile(inputStream, sftpFileOutputStream);
    }

    public void chown(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        fileAttributes.setUID(new UnsignedInteger32(n));
        this.sftp.setAttributes(string2, fileAttributes);
    }

    public void chgrp(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        fileAttributes.setGID(new UnsignedInteger32(n));
        this.sftp.setAttributes(string2, fileAttributes);
    }

    public void chmod(int n, String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        fileAttributes.setPermissions(new UnsignedInteger32(n));
        this.sftp.setAttributes(string2, fileAttributes);
    }

    public void rename(String string, String string2) throws IOException {
        String string3 = this.resolveRemotePath(string);
        String string4 = this.resolveRemotePath(string2);
        this.sftp.renameFile(string3, string4);
    }

    public void rm(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (fileAttributes.isDirectory()) {
            this.sftp.removeDirectory(string2);
        } else {
            this.sftp.removeFile(string2);
        }
    }

    public void symlink(String string, String string2) throws IOException {
        String string3 = this.resolveRemotePath(string);
        String string4 = this.resolveRemotePath(string2);
        this.sftp.createSymbolicLink(string3, string4);
    }

    public FileAttributes stat(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        return this.sftp.getAttributes(string2);
    }

    public void quit() throws IOException {
        this.sftp.stop();
    }
}

