/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.utilities;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.ActiveMQEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.KafkaEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsFirehoseInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsStreamsInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent;
import com.amazonaws.services.lambda.runtime.events.RabbitMQEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.utilities.EventDeserializationException;
import software.amazon.lambda.powertools.utilities.JsonConfig;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;
import software.amazon.lambda.powertools.utilities.jmespath.Base64GZipFunction;

public class EventDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(EventDeserializer.class);

    public static EventPart extractDataFrom(Object object) {
        if (object instanceof String) {
            return new EventPart((String)object);
        }
        if (object instanceof Map) {
            return new EventPart((Map)object);
        }
        if (object instanceof APIGatewayProxyRequestEvent) {
            APIGatewayProxyRequestEvent event = (APIGatewayProxyRequestEvent)object;
            return new EventPart(event.getBody());
        }
        if (object instanceof APIGatewayV2HTTPEvent) {
            APIGatewayV2HTTPEvent event = (APIGatewayV2HTTPEvent)object;
            return new EventPart(event.getBody());
        }
        if (object instanceof SNSEvent) {
            SNSEvent event = (SNSEvent)object;
            return new EventPart(((SNSEvent.SNSRecord)event.getRecords().get(0)).getSNS().getMessage());
        }
        if (object instanceof SQSEvent) {
            SQSEvent event = (SQSEvent)object;
            return new EventPart(event.getRecords().stream().map(SQSEvent.SQSMessage::getBody).collect(Collectors.toList()));
        }
        if (object instanceof ScheduledEvent) {
            ScheduledEvent event = (ScheduledEvent)object;
            return new EventPart(event.getDetail());
        }
        if (object instanceof ApplicationLoadBalancerRequestEvent) {
            ApplicationLoadBalancerRequestEvent event = (ApplicationLoadBalancerRequestEvent)object;
            return new EventPart(event.getBody());
        }
        if (object instanceof CloudWatchLogsEvent) {
            CloudWatchLogsEvent event = (CloudWatchLogsEvent)object;
            return new EventPart(Base64GZipFunction.decompress(Base64Function.decode(event.getAwsLogs().getData().getBytes(StandardCharsets.UTF_8))));
        }
        if (object instanceof CloudFormationCustomResourceEvent) {
            CloudFormationCustomResourceEvent event = (CloudFormationCustomResourceEvent)object;
            return new EventPart(event.getResourceProperties());
        }
        if (object instanceof KinesisEvent) {
            KinesisEvent event = (KinesisEvent)object;
            return new EventPart(event.getRecords().stream().map(r -> Base64Function.decode(r.getKinesis().getData())).collect(Collectors.toList()));
        }
        if (object instanceof KinesisFirehoseEvent) {
            KinesisFirehoseEvent event = (KinesisFirehoseEvent)object;
            return new EventPart(event.getRecords().stream().map(r -> Base64Function.decode(r.getData())).collect(Collectors.toList()));
        }
        if (object instanceof KafkaEvent) {
            KafkaEvent event = (KafkaEvent)object;
            return new EventPart(event.getRecords().values().stream().flatMap(Collection::stream).map(r -> Base64Function.decode(r.getValue())).collect(Collectors.toList()));
        }
        if (object instanceof ActiveMQEvent) {
            ActiveMQEvent event = (ActiveMQEvent)object;
            return new EventPart(event.getMessages().stream().map(m -> Base64Function.decode(m.getData())).collect(Collectors.toList()));
        }
        if (object instanceof RabbitMQEvent) {
            RabbitMQEvent event = (RabbitMQEvent)object;
            return new EventPart(event.getRmqMessagesByQueue().values().stream().flatMap(Collection::stream).map(r -> Base64Function.decode(r.getData())).collect(Collectors.toList()));
        }
        if (object instanceof KinesisAnalyticsFirehoseInputPreprocessingEvent) {
            KinesisAnalyticsFirehoseInputPreprocessingEvent event = (KinesisAnalyticsFirehoseInputPreprocessingEvent)object;
            return new EventPart(event.getRecords().stream().map(r -> Base64Function.decode(r.getData())).collect(Collectors.toList()));
        }
        if (object instanceof KinesisAnalyticsStreamsInputPreprocessingEvent) {
            KinesisAnalyticsStreamsInputPreprocessingEvent event = (KinesisAnalyticsStreamsInputPreprocessingEvent)object;
            return new EventPart(event.getRecords().stream().map(r -> Base64Function.decode(r.getData())).collect(Collectors.toList()));
        }
        LOG.warn("Consider using your object directly instead of using EventDeserializer");
        return new EventPart(object);
    }

    public static class EventPart {
        private Map<String, Object> contentMap;
        private String content;
        private List<String> contentList;
        private Object contentObject;

        private EventPart(List<String> contentList) {
            this.contentList = contentList;
        }

        private EventPart(String content) {
            this.content = content;
        }

        private EventPart(Map<String, Object> contentMap) {
            this.contentMap = contentMap;
        }

        private EventPart(Object content) {
            this.contentObject = content;
        }

        public <T> T as(Class<T> clazz) {
            try {
                if (this.content != null) {
                    if (this.content.getClass().equals(clazz)) {
                        return (T)this.content;
                    }
                    return (T)JsonConfig.get().getObjectMapper().reader().readValue(this.content, clazz);
                }
                if (this.contentMap != null) {
                    return (T)JsonConfig.get().getObjectMapper().convertValue(this.contentMap, clazz);
                }
                if (this.contentObject != null) {
                    return (T)this.contentObject;
                }
                if (this.contentList != null) {
                    throw new EventDeserializationException("The content of this event is a list, consider using 'asListOf' instead");
                }
                throw new IllegalStateException("Event content is null: the event may be malformed (missing fields)");
            }
            catch (IOException e) {
                throw new EventDeserializationException("Cannot load the event as " + clazz.getSimpleName(), e);
            }
        }

        public <T> List<T> asListOf(Class<T> clazz) {
            if (this.contentList == null && this.content == null) {
                if (this.contentMap != null || this.contentObject != null) {
                    throw new EventDeserializationException("The content of this event is not a list, consider using 'as' instead");
                }
                throw new IllegalStateException("Event content is null: the event may be malformed (missing fields)");
            }
            if (this.content != null) {
                ObjectReader reader = JsonConfig.get().getObjectMapper().readerForListOf(clazz);
                try {
                    return (List)reader.readValue(this.content);
                }
                catch (JsonProcessingException e) {
                    throw new EventDeserializationException("Cannot load the event as a list of " + clazz.getSimpleName() + ", consider using 'as' instead", (Exception)((Object)e));
                }
            }
            return this.contentList.stream().map(s -> {
                try {
                    return s == null ? null : JsonConfig.get().getObjectMapper().reader().readValue(s, clazz);
                }
                catch (IOException e) {
                    throw new EventDeserializationException("Cannot load the event as a list of " + clazz.getSimpleName(), e);
                }
            }).collect(Collectors.toList());
        }
    }
}

