/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.idempotency.persistence.dynamodb;

import java.time.Instant;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.lambda.powertools.common.internal.UserAgentConfigurator;
import software.amazon.lambda.powertools.idempotency.exceptions.IdempotencyItemAlreadyExistsException;
import software.amazon.lambda.powertools.idempotency.exceptions.IdempotencyItemNotFoundException;
import software.amazon.lambda.powertools.idempotency.persistence.BasePersistenceStore;
import software.amazon.lambda.powertools.idempotency.persistence.DataRecord;
import software.amazon.lambda.powertools.idempotency.persistence.PersistenceStore;

public class DynamoDBPersistenceStore
extends BasePersistenceStore
implements PersistenceStore {
    public static final String IDEMPOTENCY = "idempotency";
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDBPersistenceStore.class);
    private final String tableName;
    private final String keyAttr;
    private final String staticPkValue;
    private final String sortKeyAttr;
    private final String expiryAttr;
    private final String inProgressExpiryAttr;
    private final String statusAttr;
    private final String dataAttr;
    private final String validationAttr;
    private final DynamoDbClient dynamoDbClient;

    private DynamoDBPersistenceStore(String tableName, String keyAttr, String staticPkValue, String sortKeyAttr, String expiryAttr, String inProgressExpiryAttr, String statusAttr, String dataAttr, String validationAttr, DynamoDbClient client) {
        String idempotencyDisabledEnv;
        this.tableName = tableName;
        this.keyAttr = keyAttr;
        this.staticPkValue = staticPkValue;
        this.sortKeyAttr = sortKeyAttr;
        this.expiryAttr = expiryAttr;
        this.inProgressExpiryAttr = inProgressExpiryAttr;
        this.statusAttr = statusAttr;
        this.dataAttr = dataAttr;
        this.validationAttr = validationAttr;
        this.dynamoDbClient = client != null ? client : ((idempotencyDisabledEnv = System.getenv().get("POWERTOOLS_IDEMPOTENCY_DISABLED")) == null || "false".equalsIgnoreCase(idempotencyDisabledEnv) ? (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClient(UrlConnectionHttpClient.builder().build())).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)UserAgentConfigurator.getUserAgent((String)IDEMPOTENCY)).build())).region(Region.of((String)System.getenv("AWS_REGION")))).build() : null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DataRecord getRecord(String idempotencyKey) throws IdempotencyItemNotFoundException {
        GetItemResponse response = this.dynamoDbClient.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.tableName).key(this.getKey(idempotencyKey)).consistentRead(Boolean.valueOf(true)).build());
        if (!response.hasItem()) {
            throw new IdempotencyItemNotFoundException(idempotencyKey);
        }
        return this.itemToRecord(response.item());
    }

    public void putRecord(DataRecord record, Instant now) throws IdempotencyItemAlreadyExistsException {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>(this.getKey(record.getIdempotencyKey()));
        item.put(this.expiryAttr, (AttributeValue)AttributeValue.builder().n(String.valueOf(record.getExpiryTimestamp())).build());
        item.put(this.statusAttr, (AttributeValue)AttributeValue.builder().s(record.getStatus().toString()).build());
        if (record.getInProgressExpiryTimestamp().isPresent()) {
            item.put(this.inProgressExpiryAttr, (AttributeValue)AttributeValue.builder().n(String.valueOf(record.getInProgressExpiryTimestamp().getAsLong())).build());
        }
        if (this.payloadValidationEnabled) {
            item.put(this.validationAttr, (AttributeValue)AttributeValue.builder().s(record.getPayloadHash()).build());
        }
        try {
            LOG.debug("Putting record for idempotency key: {}", (Object)record.getIdempotencyKey());
            Map<String, String> expressionAttributeNames = Stream.of(new AbstractMap.SimpleEntry<String, String>("#id", this.keyAttr), new AbstractMap.SimpleEntry<String, String>("#expiry", this.expiryAttr), new AbstractMap.SimpleEntry<String, String>("#in_progress_expiry", this.inProgressExpiryAttr), new AbstractMap.SimpleEntry<String, String>("#status", this.statusAttr)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, AttributeValue> expressionAttributeValues = Stream.of(new AbstractMap.SimpleEntry<String, AttributeValue>(":now", (AttributeValue)AttributeValue.builder().n(String.valueOf(now.getEpochSecond())).build()), new AbstractMap.SimpleEntry<String, AttributeValue>(":now_milliseconds", (AttributeValue)AttributeValue.builder().n(String.valueOf(now.toEpochMilli())).build()), new AbstractMap.SimpleEntry<String, AttributeValue>(":inprogress", (AttributeValue)AttributeValue.builder().s(DataRecord.Status.INPROGRESS.toString()).build())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.dynamoDbClient.putItem((PutItemRequest)PutItemRequest.builder().tableName(this.tableName).item(item).conditionExpression("attribute_not_exists(#id) OR #expiry < :now OR (attribute_exists(#in_progress_expiry) AND #in_progress_expiry < :now_milliseconds AND #status = :inprogress)").expressionAttributeNames(expressionAttributeNames).expressionAttributeValues(expressionAttributeValues).returnValuesOnConditionCheckFailure("ALL_OLD").build());
        }
        catch (ConditionalCheckFailedException e) {
            LOG.debug("Failed to put record for already existing idempotency key: {}", (Object)record.getIdempotencyKey());
            if (e.hasItem()) {
                DataRecord existingRecord = this.itemToRecord(e.item());
                throw new IdempotencyItemAlreadyExistsException("Failed to put record for already existing idempotency key: " + record.getIdempotencyKey() + ". Existing record: " + existingRecord, (Throwable)e, existingRecord);
            }
            throw new IdempotencyItemAlreadyExistsException("Failed to put record for already existing idempotency key: " + record.getIdempotencyKey(), (Throwable)e);
        }
    }

    public void updateRecord(DataRecord record) {
        LOG.debug("Updating record for idempotency key: {}", (Object)record.getIdempotencyKey());
        String updateExpression = "SET #response_data = :response_data, #expiry = :expiry, #status = :status";
        Map<String, String> expressionAttributeNames = Stream.of(new AbstractMap.SimpleEntry<String, String>("#response_data", this.dataAttr), new AbstractMap.SimpleEntry<String, String>("#expiry", this.expiryAttr), new AbstractMap.SimpleEntry<String, String>("#status", this.statusAttr)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, AttributeValue> expressionAttributeValues = Stream.of(new AbstractMap.SimpleEntry<String, AttributeValue>(":response_data", (AttributeValue)AttributeValue.builder().s(record.getResponseData()).build()), new AbstractMap.SimpleEntry<String, AttributeValue>(":expiry", (AttributeValue)AttributeValue.builder().n(String.valueOf(record.getExpiryTimestamp())).build()), new AbstractMap.SimpleEntry<String, AttributeValue>(":status", (AttributeValue)AttributeValue.builder().s(record.getStatus().toString()).build())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.payloadValidationEnabled) {
            updateExpression = String.valueOf(updateExpression) + ", #validation_key = :validation_key";
            expressionAttributeNames.put("#validation_key", this.validationAttr);
            expressionAttributeValues.put(":validation_key", (AttributeValue)AttributeValue.builder().s(record.getPayloadHash()).build());
        }
        this.dynamoDbClient.updateItem((UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(this.getKey(record.getIdempotencyKey())).updateExpression(updateExpression).expressionAttributeNames(expressionAttributeNames).expressionAttributeValues(expressionAttributeValues).build());
    }

    public void deleteRecord(String idempotencyKey) {
        LOG.debug("Deleting record for idempotency key: {}", (Object)idempotencyKey);
        this.dynamoDbClient.deleteItem((DeleteItemRequest)DeleteItemRequest.builder().tableName(this.tableName).key(this.getKey(idempotencyKey)).build());
    }

    private Map<String, AttributeValue> getKey(String idempotencyKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        if (this.sortKeyAttr != null) {
            key.put(this.keyAttr, (AttributeValue)AttributeValue.builder().s(this.staticPkValue).build());
            key.put(this.sortKeyAttr, (AttributeValue)AttributeValue.builder().s(idempotencyKey).build());
        } else {
            key.put(this.keyAttr, (AttributeValue)AttributeValue.builder().s(idempotencyKey).build());
        }
        return key;
    }

    private DataRecord itemToRecord(Map<String, AttributeValue> item) {
        AttributeValue data = item.get(this.dataAttr);
        AttributeValue validation = item.get(this.validationAttr);
        return new DataRecord(item.get(this.sortKeyAttr != null ? this.sortKeyAttr : this.keyAttr).s(), DataRecord.Status.valueOf((String)item.get(this.statusAttr).s()), Long.parseLong(item.get(this.expiryAttr).n()), data != null ? data.s() : null, validation != null ? validation.s() : null, item.get(this.inProgressExpiryAttr) != null ? OptionalLong.of(Long.parseLong(item.get(this.inProgressExpiryAttr).n())) : OptionalLong.empty());
    }

    public static class Builder {
        private static final String funcEnv = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
        private String tableName;
        private String keyAttr = "id";
        private String staticPkValue = String.format("idempotency#%s", funcEnv != null ? funcEnv : "");
        private String sortKeyAttr;
        private String expiryAttr = "expiration";
        private String inProgressExpiryAttr = "in_progress_expiration";
        private String statusAttr = "status";
        private String dataAttr = "data";
        private String validationAttr = "validation";
        private DynamoDbClient dynamoDbClient;

        public DynamoDBPersistenceStore build() {
            if (this.tableName == null || "".equals(this.tableName)) {
                throw new IllegalArgumentException("Table name is not specified");
            }
            return new DynamoDBPersistenceStore(this.tableName, this.keyAttr, this.staticPkValue, this.sortKeyAttr, this.expiryAttr, this.inProgressExpiryAttr, this.statusAttr, this.dataAttr, this.validationAttr, this.dynamoDbClient);
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withKeyAttr(String keyAttr) {
            this.keyAttr = keyAttr;
            return this;
        }

        public Builder withStaticPkValue(String staticPkValue) {
            this.staticPkValue = staticPkValue;
            return this;
        }

        public Builder withSortKeyAttr(String sortKeyAttr) {
            this.sortKeyAttr = sortKeyAttr;
            return this;
        }

        public Builder withExpiryAttr(String expiryAttr) {
            this.expiryAttr = expiryAttr;
            return this;
        }

        public Builder withInProgressExpiryAttr(String inProgressExpiryAttr) {
            this.inProgressExpiryAttr = inProgressExpiryAttr;
            return this;
        }

        public Builder withStatusAttr(String statusAttr) {
            this.statusAttr = statusAttr;
            return this;
        }

        public Builder withDataAttr(String dataAttr) {
            this.dataAttr = dataAttr;
            return this;
        }

        public Builder withValidationAttr(String validationAttr) {
            this.validationAttr = validationAttr;
            return this;
        }

        public Builder withDynamoDbClient(DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }
    }
}

