/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.idempotency;

import com.amazonaws.services.lambda.runtime.Context;
import software.amazon.lambda.powertools.idempotency.IdempotencyConfig;
import software.amazon.lambda.powertools.idempotency.persistence.BasePersistenceStore;

public class Idempotency {
    private IdempotencyConfig config;
    private BasePersistenceStore persistenceStore;

    private Idempotency() {
    }

    public static Idempotency getInstance() {
        return Holder.instance;
    }

    public static void registerLambdaContext(Context lambdaContext) {
        Idempotency.getInstance().getConfig().setLambdaContext(lambdaContext);
    }

    public static Config config() {
        return new Config();
    }

    public IdempotencyConfig getConfig() {
        return this.config;
    }

    private void setConfig(IdempotencyConfig config) {
        this.config = config;
    }

    public BasePersistenceStore getPersistenceStore() {
        if (this.persistenceStore == null) {
            throw new IllegalStateException("Persistence Store is null, did you call 'configure()'?");
        }
        return this.persistenceStore;
    }

    private void setPersistenceStore(BasePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
    }

    public static class Config {
        private IdempotencyConfig config;
        private BasePersistenceStore store;

        public void configure() {
            if (this.store == null) {
                throw new IllegalStateException("Persistence Layer is null, configure one with 'withPersistenceStore()'");
            }
            if (this.config == null) {
                this.config = IdempotencyConfig.builder().build();
            }
            Idempotency.getInstance().setConfig(this.config);
            Idempotency.getInstance().setPersistenceStore(this.store);
        }

        public Config withPersistenceStore(BasePersistenceStore persistenceStore) {
            this.store = persistenceStore;
            return this;
        }

        public Config withConfig(IdempotencyConfig config) {
            this.config = config;
            return this;
        }
    }

    private static class Holder {
        private static final Idempotency instance = new Idempotency();

        private Holder() {
        }
    }
}

