/*
 * Decompiled with CFR 0.152.
 */
package sh.calvin.autolinktext;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLinkStyles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sh.calvin.autolinktext.ContextData;
import sh.calvin.autolinktext.SimpleTextMatchResult;
import sh.calvin.autolinktext.TextMatchResult;
import sh.calvin.autolinktext.TextRule;
import sh.calvin.autolinktext.TextRuleDefaultsInterface;
import sh.calvin.autolinktext.TextRuleKt;
import sh.calvin.autolinktext.TextRule_jvmKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\u001a\u001e\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r\u001a$\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001e\u0010\u000e\u001a\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00142\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a2\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\u0014\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a*\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\u0014\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\u0014H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"NullContextData", "Lsh/calvin/autolinktext/ContextData;", "getNullContextData", "()Lsh/calvin/autolinktext/ContextData;", "TextRuleDefaults", "Lsh/calvin/autolinktext/TextRuleDefaultsInterface;", "getTextRuleDefaults", "()Lsh/calvin/autolinktext/TextRuleDefaultsInterface;", "addMatch", "", "T", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "match", "Lsh/calvin/autolinktext/TextMatchResult;", "annotateString", "Landroidx/compose/ui/text/AnnotatedString;", "", "Lsh/calvin/autolinktext/TextRule;", "text", "", "", "getAllMatches", "pruneOverlaps", "autolinktext"})
@SourceDebugExtension(value={"SMAP\nTextRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRule.kt\nsh/calvin/autolinktext/TextRuleKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1360#2:306\n1446#2,2:307\n1549#2:309\n1620#2,3:310\n1448#2,3:313\n1855#2,2:316\n*S KotlinDebug\n*F\n+ 1 TextRule.kt\nsh/calvin/autolinktext/TextRuleKt\n*L\n192#1:306\n192#1:307,2\n193#1:309\n193#1:310,3\n192#1:313,3\n249#1:316,2\n*E\n"})
public final class TextRuleKt {
    @NotNull
    private static final ContextData NullContextData = new ContextData(){};
    @NotNull
    private static final TextRuleDefaultsInterface TextRuleDefaults = TextRule_jvmKt.getTextRuleDefaults();

    @NotNull
    public static final ContextData getNullContextData() {
        return NullContextData;
    }

    @NotNull
    public static final TextRuleDefaultsInterface getTextRuleDefaults() {
        return TextRuleDefaults;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<TextMatchResult<T>> getAllMatches(@NotNull Collection<? extends TextRule<T>> $this$getAllMatches, @NotNull String text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getAllMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$flatMap$iv = $this$getAllMatches;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRule rule = (TextRule)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = rule.getTextMatcher().apply(text);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void match;
                SimpleTextMatchResult simpleTextMatchResult = (SimpleTextMatchResult)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new TextMatchResult(rule, text, match));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return TextRuleKt.pruneOverlaps((List)destination$iv$iv);
    }

    private static final <T> List<TextMatchResult<T>> pruneOverlaps(List<TextMatchResult<T>> $this$pruneOverlaps) {
        List sortedList2 = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$pruneOverlaps, (arg_0, arg_1) -> TextRuleKt.pruneOverlaps$lambda$2(pruneOverlaps.sortedList.1.INSTANCE, arg_0, arg_1)));
        int len = sortedList2.size();
        int i = 0;
        while (i < len - 1) {
            TextMatchResult a = (TextMatchResult)sortedList2.get(i);
            TextMatchResult b = (TextMatchResult)sortedList2.get(i + 1);
            int remove = -1;
            if (a.getStart() <= b.getStart() && a.getEndExclusive() > b.getStart()) {
                if (b.getEndExclusive() <= a.getEndExclusive()) {
                    remove = i + 1;
                } else if (a.getEndExclusive() - a.getStart() > b.getEndExclusive() - b.getStart()) {
                    remove = i + 1;
                } else if (a.getEndExclusive() - a.getStart() < b.getEndExclusive() - b.getStart()) {
                    remove = i;
                }
                if (remove != -1) {
                    sortedList2.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
        return sortedList2;
    }

    @NotNull
    public static final AnnotatedString annotateString(@NotNull List<? extends TextMatchResult<?>> $this$annotateString, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$annotateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        AnnotatedString.Builder annotatedString = new AnnotatedString.Builder(text);
        Iterable $this$forEach$iv = $this$annotateString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextMatchResult match = (TextMatchResult)element$iv;
            boolean bl = false;
            TextRuleKt.addMatch(annotatedString, match);
        }
        return annotatedString.toAnnotatedString();
    }

    public static final <T> void addMatch(@NotNull AnnotatedString.Builder $this$addMatch, @NotNull TextMatchResult<T> match) {
        block2: {
            TextRule<T> textRule;
            TextLinkStyles styles;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$addMatch, (String)"<this>");
                    Intrinsics.checkNotNullParameter(match, (String)"match");
                    Function1<TextMatchResult<T>, TextLinkStyles> function1 = match.getRule().getStylesProvider();
                    styles = function1 != null ? (TextLinkStyles)function1.invoke(match) : null;
                    textRule = match.getRule();
                    if (!(textRule instanceof TextRule.Url)) break block1;
                    String url = (String)((TextRule.Url)match.getRule()).getUrlProvider().invoke(match);
                    if (url == null) break block2;
                    $this$addMatch.addLink(new LinkAnnotation.Url(url, styles, null, 4, null), match.getStart().intValue(), match.getEndExclusive().intValue());
                    break block2;
                }
                if (!(textRule instanceof TextRule.Clickable)) break block3;
                $this$addMatch.addLink(new LinkAnnotation.Clickable("", styles, arg_0 -> TextRuleKt.addMatch$lambda$4(match, arg_0)), match.getStart().intValue(), match.getEndExclusive().intValue());
                break block2;
            }
            if (!(textRule instanceof TextRule.Styleable)) break block2;
            TextLinkStyles textLinkStyles = styles;
            if (textLinkStyles != null && (textLinkStyles = textLinkStyles.getStyle()) != null) {
                TextLinkStyles it = textLinkStyles;
                boolean bl = false;
                $this$addMatch.addStyle((SpanStyle)it, match.getStart().intValue(), match.getEndExclusive().intValue());
            }
        }
    }

    @NotNull
    public static final <T> AnnotatedString annotateString(@NotNull Collection<? extends TextRule<T>> $this$annotateString, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$annotateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<TextMatchResult<T>> matches = TextRuleKt.getAllMatches($this$annotateString, text);
        return TextRuleKt.annotateString(matches, text);
    }

    private static final int pruneOverlaps$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void addMatch$lambda$4(TextMatchResult $match, LinkAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((TextRule.Clickable)$match.getRule()).getOnClick().invoke((Object)$match);
    }
}

