/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private PrintWriter writer;
    private LinkedList elementStack = new LinkedList();
    private boolean tagInProgress;
    private int depth;
    private String lineIndenter;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;

    public PrettyPrintXMLWriter(PrintWriter printWriter) {
        this(printWriter, "  ");
    }

    public PrettyPrintXMLWriter(PrintWriter printWriter, String string) {
        this.writer = printWriter;
        this.lineIndenter = string;
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(Writer writer, String string) {
        this(new PrintWriter(writer), string);
    }

    public void addAttribute(String string, String string2) {
        this.write(" ");
        this.write(string);
        this.write("=\"");
        this.write(string2);
        this.write("\"");
    }

    public void endElement() {
        --this.depth;
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.removeLast();
        } else {
            this.finishTag();
            this.write("</" + this.elementStack.removeLast() + ">");
        }
        this.readyForNewLine = true;
    }

    protected void endOfLine() {
        this.write("\n");
        int n = 0;
        while (n < this.depth) {
            this.write(this.lineIndenter);
            ++n;
        }
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    public void startElement(String string) {
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(string);
        this.elementStack.addLast(string);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    private void write(String string) {
        this.writer.write(string);
    }

    public void writeText(String string) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        this.write(string);
    }
}

