/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.InputStream;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    public static int executeCommandLine(Commandline commandline, InputStream inputStream, StreamConsumer streamConsumer, StreamConsumer streamConsumer2) throws CommandLineException {
        if (commandline == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process process = commandline.execute();
        StreamFeeder streamFeeder = null;
        if (inputStream != null) {
            streamFeeder = new StreamFeeder(inputStream, process.getOutputStream());
        }
        StreamPumper streamPumper = new StreamPumper(process.getInputStream(), streamConsumer);
        StreamPumper streamPumper2 = new StreamPumper(process.getErrorStream(), streamConsumer2);
        if (streamFeeder != null) {
            streamFeeder.start();
        }
        streamPumper.start();
        streamPumper2.start();
        try {
            try {
                Thread thread;
                int n = process.waitFor();
                if (streamFeeder != null) {
                    thread = streamFeeder;
                    synchronized (thread) {
                        if (!streamFeeder.isDone()) {
                            streamFeeder.wait();
                        }
                    }
                }
                if (streamPumper != null) {
                    thread = streamPumper;
                    synchronized (thread) {
                        if (!streamPumper.isDone()) {
                            streamPumper.wait();
                        }
                    }
                }
                if (streamPumper2 != null) {
                    thread = streamPumper2;
                    synchronized (thread) {
                        if (!streamPumper2.isDone()) {
                            streamPumper2.wait();
                        }
                    }
                }
                int n2 = n;
                Object var10_12 = null;
                if (streamFeeder != null) {
                    streamFeeder.close();
                }
                streamPumper.close();
                streamPumper2.close();
                return n2;
            }
            catch (InterruptedException interruptedException) {
                throw new CommandLineException("Error while executing external command.", interruptedException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (streamFeeder != null) {
                streamFeeder.close();
            }
            streamPumper.close();
            streamPumper2.close();
            throw throwable;
        }
    }

    public static int executeCommandLine(Commandline commandline, StreamConsumer streamConsumer, StreamConsumer streamConsumer2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(commandline, null, streamConsumer, streamConsumer2);
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String string) {
            this.string.append(String.valueOf(string) + this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

