/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.ArrayList;

public class SweeperPool {
    private static final boolean DEBUG = false;
    private transient Sweeper sweeper;
    private transient int maxSize;
    private transient int minSize;
    private int triggerSize;
    private ArrayList pooledObjects;
    private boolean shuttingDown = false;

    public SweeperPool(int n, int n2, int n3, int n4, int n5) {
        this.maxSize = this.saneConvert(n);
        this.minSize = this.saneConvert(n2);
        this.triggerSize = this.saneConvert(n5);
        this.pooledObjects = new ArrayList(n3);
        if (n4 > 0) {
            this.sweeper = new Sweeper(this, n4);
            this.sweeper.start();
        }
    }

    public synchronized void dispose() {
        this.shuttingDown = true;
        if (this.sweeper != null) {
            this.sweeper.stop();
        }
        Object[] objectArray = this.pooledObjects.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.objectDisposed(objectArray[n]);
            ++n;
        }
        this.pooledObjects.clear();
    }

    public synchronized Object get() {
        if (this.pooledObjects.size() == 0 || this.shuttingDown) {
            return null;
        }
        Object e = this.pooledObjects.remove(0);
        this.objectRetrieved(e);
        return e;
    }

    public synchronized int getSize() {
        return this.pooledObjects.size();
    }

    public void objectAdded(Object object) {
    }

    public void objectDisposed(Object object) {
    }

    public void objectRetrieved(Object object) {
    }

    public synchronized boolean put(Object object) {
        this.objectAdded(object);
        if (object != null && this.pooledObjects.size() < this.maxSize && !this.shuttingDown) {
            this.pooledObjects.add(object);
            return true;
        }
        if (object != null) {
            this.objectDisposed(object);
        }
        return false;
    }

    private int saneConvert(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public synchronized void trim() {
        if (this.triggerSize > 0 && this.pooledObjects.size() >= this.triggerSize || this.maxSize > 0 && this.pooledObjects.size() >= this.maxSize) {
            while (this.pooledObjects.size() > this.minSize) {
                this.objectDisposed(this.pooledObjects.remove(0));
            }
        }
    }

    private static class Sweeper
    implements Runnable {
        private final transient SweeperPool pool;
        private transient boolean service = false;
        private final transient int sweepInterval;

        public Sweeper(SweeperPool sweeperPool, int n) {
            this.sweepInterval = n;
            this.pool = sweeperPool;
        }

        private final void debug(String string) {
        }

        public void run() {
            this.debug("started");
            if (this.sweepInterval > 0) {
                Sweeper sweeper = this;
                synchronized (sweeper) {
                    while (this.service) {
                        try {
                            this.wait(this.sweepInterval * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.runSweep();
                    }
                }
            }
            this.debug("stopped");
        }

        private void runSweep() {
            this.debug("runningSweep. time=" + System.currentTimeMillis());
            this.pool.trim();
        }

        public synchronized void start() {
            if (!this.service) {
                this.service = true;
                Thread thread = new Thread(this);
                thread.start();
            }
        }

        public synchronized void stop() {
            this.service = false;
            this.notifyAll();
        }
    }
}

