/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.codehaus.plexus.util.SelectorUtils;

public class DirectoryScanner {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;

    public void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + DEFAULTEXCLUDES.length];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        int n2 = 0;
        while (n2 < DEFAULTEXCLUDES.length) {
            stringArray[n2 + n] = DEFAULTEXCLUDES[n2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++n2;
        }
        this.excludes = stringArray;
    }

    protected boolean couldHoldIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getIncludedDirectories() {
        Object[] objectArray = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getIncludedFiles() {
        Object[] objectArray = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    protected boolean isExcluded(String string) {
        int n = 0;
        while (n < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isSelected(String string, File file) {
        return true;
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        File file2 = new File(file.getCanonicalPath());
        File file3 = new File(file2, string);
        return file3.getAbsolutePath().equals(file3.getCanonicalPath()) ^ true;
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2);
    }

    protected static boolean match(String string, String string2, boolean bl) {
        return SelectorUtils.match(string, string2, bl);
    }

    protected static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2);
    }

    protected static boolean matchPath(String string, String string2, boolean bl) {
        return SelectorUtils.matchPath(string, string2, bl);
    }

    protected static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl) {
        return SelectorUtils.matchPatternStart(string, string2, bl);
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void scandir(File file, String string, boolean bl) {
        Object object;
        Object[] objectArray = file.list();
        if (!this.followSymlinks) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < objectArray.length) {
                try {
                    if (this.isSymbolicLink(file, objectArray[n])) {
                        object = String.valueOf(string) + (String)objectArray[n];
                        File file2 = new File(file, (String)objectArray[n]);
                        if (file2.isDirectory()) {
                            this.dirsExcluded.addElement(object);
                        } else {
                            this.filesExcluded.addElement(object);
                        }
                    } else {
                        vector.addElement(objectArray[n]);
                    }
                }
                catch (IOException iOException) {
                    object = "IOException caught while checking for links, couldn't get cannonical path!";
                    System.err.println((String)object);
                    vector.addElement(objectArray[n]);
                }
                ++n;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            String string2 = String.valueOf(string) + objectArray[n];
            object = new File(file, (String)objectArray[n]);
            if (((File)object).isDirectory()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        if (this.isSelected(string2, (File)object)) {
                            this.dirsIncluded.addElement(string2);
                            if (bl) {
                                this.scandir((File)object, String.valueOf(string2) + File.separator, bl);
                            }
                        } else {
                            this.everythingIncluded = false;
                            this.dirsDeselected.addElement(string2);
                            if (bl && this.couldHoldIncluded(string2)) {
                                this.scandir((File)object, String.valueOf(string2) + File.separator, bl);
                            }
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.dirsExcluded.addElement(string2);
                        if (bl && this.couldHoldIncluded(string2)) {
                            this.scandir((File)object, String.valueOf(string2) + File.separator, bl);
                        }
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (bl && this.couldHoldIncluded(string2)) {
                        this.scandir((File)object, String.valueOf(string2) + File.separator, bl);
                    }
                }
                if (!bl) {
                    this.scandir((File)object, String.valueOf(string2) + File.separator, bl);
                }
            } else if (((File)object).isFile()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        if (this.isSelected(string2, (File)object)) {
                            this.filesIncluded.addElement(string2);
                        } else {
                            this.everythingIncluded = false;
                            this.filesDeselected.addElement(string2);
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.filesExcluded.addElement(string2);
                    }
                } else {
                    this.everythingIncluded = false;
                    this.filesNotIncluded.addElement(string2);
                }
            }
            ++n;
        }
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = String.valueOf(string) + "**";
                }
                this.excludes[n] = string;
                ++n;
            }
        }
    }

    public void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = String.valueOf(string) + "**";
                }
                this.includes[n] = string;
                ++n;
            }
        }
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.couldHoldIncluded((String)objectArray[n])) {
                this.scandir(new File(this.basedir, (String)objectArray[n]), String.valueOf(objectArray[n]) + File.separator, false);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            if (!this.couldHoldIncluded((String)objectArray2[n2])) {
                this.scandir(new File(this.basedir, (String)objectArray2[n2]), String.valueOf(objectArray2[n2]) + File.separator, false);
            }
            ++n2;
        }
        this.haveSlowResults = true;
    }
}

