/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pull;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.summit.pull.PullService;
import org.codehaus.plexus.summit.pull.RequestTool;
import org.codehaus.plexus.summit.pull.Tool;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;

public class DefaultPullService
extends AbstractLogEnabled
implements PullService,
Contextualizable,
Initializable,
Disposable {
    public static final String GLOBAL_SCOPE = "global";
    public static final String REQUEST_SCOPE = "request";
    public static final String SESSION_SCOPE = "session";
    private Map globalTools = new HashMap();
    private Map sessionTools = new HashMap();
    private Map requestTools = new HashMap();
    private PlexusContainer container;
    private List tools;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        Iterator i = this.tools.iterator();
        while (i.hasNext()) {
            Tool tool = (Tool)i.next();
            if (tool.getScope().equals(GLOBAL_SCOPE)) {
                Object o;
                try {
                    o = tool.getRoleHint() == null ? this.container.lookup(tool.getRole()) : this.container.lookup(tool.getRole(), tool.getRoleHint());
                }
                catch (ComponentLookupException e) {
                    throw new InitializationException("Error looking up global tool: ", (Throwable)e);
                }
                this.globalTools.put(tool.getName(), o);
                continue;
            }
            if (tool.getScope().equals(REQUEST_SCOPE)) {
                this.requestTools.put(tool.getName(), tool.getRole());
                continue;
            }
            if (!tool.getScope().equals(SESSION_SCOPE)) continue;
            this.sessionTools.put(tool.getName(), tool.getRole());
        }
    }

    public void populateContext(ViewContext context, RunData data) {
        this.populateWithGlobalTools(context);
        this.populateWithRequestTools(context, data);
        this.populateWithSessionTools(context, data);
    }

    protected void populateWithGlobalTools(ViewContext context) {
        context.putAll(this.globalTools);
    }

    protected void populateWithRequestTools(ViewContext context, RunData data) {
        Iterator itr = this.requestTools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            try {
                Object component = this.container.lookup((String)this.requestTools.get(key));
                this.setRequestRunData(component, data);
                context.put(key, component);
            }
            catch (Exception e) {
                this.getLogger().error("Couldn't find request tool " + key + " with role " + this.requestTools.get(key) + ".", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateWithSessionTools(ViewContext context, RunData data) {
        Iterator itr = this.sessionTools.keySet().iterator();
        while (itr.hasNext()) {
            HttpSession session;
            String key = (String)itr.next();
            HttpSession httpSession = session = data.getSession();
            synchronized (httpSession) {
                Object tool = session.getAttribute(key);
                if (tool == null) {
                    try {
                        tool = this.container.lookup((String)this.sessionTools.get(key));
                        session.setAttribute(key, tool);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Could find request tool " + key + " with role " + this.sessionTools.get(key) + ".", (Throwable)e);
                        break;
                    }
                }
                context.put(key, tool);
            }
        }
    }

    protected void setRequestRunData(Object component, RunData data) {
        if (component instanceof RequestTool) {
            ((RequestTool)component).setRunData(data);
        }
    }

    public void releaseTools(ViewContext context) {
        try {
            this.releaseTools(context, this.requestTools);
        }
        catch (Exception e) {
            this.getLogger().error("Problem releasing tools: ", (Throwable)e);
        }
    }

    protected void releaseTools(ViewContext context, Map tools) throws Exception {
        Iterator itr = tools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object tool = context.remove(key);
            this.container.release(tool);
        }
    }

    public void dispose() {
        try {
            this.disposeGlobalTools();
        }
        catch (Exception e) {
            this.getLogger().error("Problem disposing global tools: ", (Throwable)e);
        }
        this.container = null;
    }

    private void disposeGlobalTools() throws Exception {
        Iterator itr = this.globalTools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.container.release(this.globalTools.remove(key));
        }
    }
}

