/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.plexus.summit.AbstractSummitComponent;
import org.codehaus.plexus.summit.pipeline.Pipeline;
import org.codehaus.plexus.summit.pipeline.valve.Valve;
import org.codehaus.plexus.summit.pipeline.valve.ValveInvocationException;
import org.codehaus.plexus.summit.rundata.RunData;

public abstract class AbstractPipeline
extends AbstractSummitComponent
implements Pipeline,
Configurable {
    protected String name;
    protected List valves = new ArrayList();
    protected boolean nocache;

    public String getName() {
        return this.name;
    }

    public void invoke(RunData data) throws IOException, ValveInvocationException {
        if (this.nocache) {
            data.getResponse().setHeader("Pragma", "No-cache");
            data.getResponse().setHeader("Cache-Control", "no-cache");
            data.getResponse().setDateHeader("Exprires", 1L);
        }
        Iterator iterator = this.valves.iterator();
        while (iterator.hasNext()) {
            Valve valve = (Valve)iterator.next();
            valve.invoke(data);
        }
    }

    public List getValves() {
        return this.valves;
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        String nocacheValue = config.getChild("nocache").getValue();
        if (nocacheValue != null) {
            this.nocache = new Boolean(nocacheValue);
        }
        PlexusConfiguration[] valves = config.getChild("valves").getChildren("valve");
        for (int i = 0; i < valves.length; ++i) {
            this.configureValve(valves[i]);
        }
    }

    protected void configureValve(PlexusConfiguration config) throws PlexusConfigurationException {
        String name = config.getValue();
        Valve valve = null;
        try {
            valve = (Valve)this.getContainer().lookup(Valve.ROLE, name);
        }
        catch (ComponentLookupException e) {
            throw new PlexusConfigurationException("Couldn't create valve with role-hint = " + name, (Throwable)e);
        }
        this.valves.add(valve);
    }
}

