package org.codehaus.plexus.summit.resolver;

/*
 * Copyright 2004-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.HashMap;
import java.util.Map;

import org.codehaus.plexus.summit.view.View;

/**
 * <p>A <code>Resolution</code> is the result of target view processing that occurs
 * within a {@link org.codehaus.plexus.summit.resolver.Resolver}. </p>
 *
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: Resolution.java 2092 2005-06-06 16:31:27Z jvanzyl $
 */
public class Resolution
{
    private Map resolution;

    public Resolution()
    {
        resolution = new HashMap();
    }

    public void put( Object key, Object value )
    {
        resolution.put( key, value );
    }

    public Object get( Object key )
    {
        return resolution.get( key );
    }

    public View getView( String key )
    {
        return (View) get( key );
    }
}
