/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.FastArrayList;

public class ResolverUtils {
    public static List getPossibleViews(String target, String defaultBaseName) throws Exception {
        ArrayList<String> views = new ArrayList<String>();
        StringBuffer view = new StringBuffer();
        int i = ResolverUtils.parseTargetPath(target, view);
        if (view.charAt(0) == '/') {
            view.deleteCharAt(0);
            --i;
        }
        int j = i + 1;
        while (j < view.length()) {
            if (view.charAt(j) == '.') {
                view.delete(j, view.length());
                break;
            }
            ++j;
        }
        int j2 = 9999;
        while (j2-- > 0) {
            String module = view.toString();
            views.add(module);
            view.setLength(i + 1);
            if (i > 0) {
                i = view.length() - 2;
                while (i >= 0) {
                    if (view.charAt(i) != '/') {
                        --i;
                        continue;
                    }
                    break;
                }
            } else if (j2 > 0) {
                j2 = 1;
            }
            view.append(defaultBaseName);
        }
        return views;
    }

    public static List getPossibleModules(List views) throws Exception {
        ArrayList<String> modules = new ArrayList<String>();
        Iterator i = views.iterator();
        while (i.hasNext()) {
            String view = (String)i.next();
            modules.add(ResolverUtils.viewToClassName(view));
        }
        return modules;
    }

    public static int parseTargetPath(String target, StringBuffer buffer) throws Exception {
        int j = 0;
        int index = -1;
        buffer.setLength(0);
        buffer.append(target);
        int len = buffer.length();
        while (j < len) {
            char c = buffer.charAt(j);
            if (c == ',') {
                c = '/';
                buffer.setCharAt(j, c);
            }
            if (c == '/') {
                index = j;
                if (j < len - 1 && ((c = buffer.charAt(j + 1)) == '/' || c == ',')) {
                    buffer.deleteCharAt(j);
                    --len;
                    continue;
                }
            }
            ++j;
        }
        if (len == 0 || index >= len - 1) {
            throw new Exception("Syntax error in template name '" + target + '\'');
        }
        return index;
    }

    public static String viewToClassName(String view) {
        StringBuffer sb = new StringBuffer(view);
        if (sb.charAt(0) == '/') {
            sb.deleteCharAt(0);
        }
        int j = 0;
        while (j < sb.length()) {
            if (sb.charAt(j) == '/') {
                sb.setCharAt(j, '.');
            }
            ++j;
        }
        return sb.toString();
    }

    public static List getPossibleModuleSuffixes(String target, String defaultBaseName) throws Exception {
        List views = ResolverUtils.getPossibleViews(target, defaultBaseName);
        FastArrayList modules = new FastArrayList();
        Iterator i = views.iterator();
        while (i.hasNext()) {
            modules.add(ResolverUtils.viewToClassName((String)i.next()));
        }
        return modules;
    }

    public boolean targetHasExtension(String target) {
        return target.indexOf(".") > 0;
    }
}

