/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit.resolver;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.summit.module.Module;
import org.apache.plexus.summit.resolver.AbstractResolver;
import org.apache.plexus.summit.resolver.Resolution;
import org.apache.plexus.summit.view.View;

public class ClassicResolver
extends AbstractResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$resolver$ClassicResolver == null ? (class$org$apache$plexus$summit$resolver$ClassicResolver = ClassicResolver.class$("org.apache.plexus.summit.resolver.ClassicResolver")) : class$org$apache$plexus$summit$resolver$ClassicResolver));
    public static final String DEFAULT_LAYOUT_MODULE = "Default";
    public static final String DEFAULT_LAYOUT_MODULE_KEY = "defaultLayoutModule";
    public static final String DEFAULT_NAV_MODULE = "Default";
    public static final String DEFAULT_NAV_MODULE_KEY = "defaultLayoutModule";
    public static final String DEFAULT_SCREEN_MODULE = "Default";
    public static final String DEFAULT_SCREEN_MODULE_KEY = "defaultLayoutModule";
    public static final String LAYOUT_MODULE = "layoutModule";
    public static final String LAYOUT_VIEW = "layoutView";
    public static final String NAVIGATION_MODULE = "navigationModule";
    public static final String NAVIGATION_VIEW = "navigationView";
    public static final String SCREEN_MODULE = "screenModule";
    public static final String SCREEN_VIEW = "screenView";
    private static final String LAYOUT_TARGET_PREFIX = "layouts";
    private static final String NAVIGATION_TARGET_PREFIX = "navigations";
    private static final String SCREEN_TARGET_PREFIX = "screens";
    private String defaultLayoutModule;
    private String defaultNavigationModule;
    private String defaultScreenModule;
    static /* synthetic */ Class class$org$apache$plexus$summit$resolver$ClassicResolver;

    public void setDefaultLayoutModule(String defaultLayoutModule) {
        this.defaultLayoutModule = defaultLayoutModule;
    }

    public String getDefaultLayoutModule() {
        return this.defaultLayoutModule;
    }

    public void setDefaultNavigationModule(String defaultNavigationModule) {
        this.defaultNavigationModule = defaultNavigationModule;
    }

    public String getDefaultNavigationModule() {
        return this.defaultNavigationModule;
    }

    public void setDefaultScreenModule(String defaultScreenModule) {
        this.defaultScreenModule = defaultScreenModule;
    }

    public String getDefaultScreenModule() {
        return this.defaultScreenModule;
    }

    public Resolution resolve(String target) throws Exception {
        Resolution resolution = new Resolution();
        Module layoutModule = this.getLayoutModule(target);
        resolution.put(LAYOUT_MODULE, layoutModule);
        log.info((Object)("Layout Module: " + layoutModule));
        View layoutView = this.getView(target, LAYOUT_TARGET_PREFIX);
        resolution.put(LAYOUT_VIEW, layoutView);
        log.info((Object)("Layout View: " + layoutView));
        Module navigationModule = this.getNavigationModule(target);
        resolution.put(NAVIGATION_MODULE, navigationModule);
        log.info((Object)("Navigation Module: " + navigationModule));
        View navigationView = this.getView(target, NAVIGATION_TARGET_PREFIX);
        resolution.put(NAVIGATION_VIEW, navigationView);
        log.info((Object)("Navigation View: " + navigationView));
        Module screenModule = this.getScreenModule(target);
        resolution.put(SCREEN_MODULE, screenModule);
        log.info((Object)("Screen Module: " + screenModule));
        View screenView = this.getView(target, SCREEN_TARGET_PREFIX);
        resolution.put(SCREEN_VIEW, screenView);
        log.info((Object)("Screen View: " + screenView));
        return resolution;
    }

    protected Module getLayoutModule(String target) throws Exception {
        return this.getModule(target, LAYOUT_TARGET_PREFIX, this.getDefaultLayoutModule());
    }

    protected Module getNavigationModule(String target) throws Exception {
        return this.getModule(target, NAVIGATION_TARGET_PREFIX, this.getDefaultNavigationModule());
    }

    protected Module getScreenModule(String target) throws Exception {
        return this.getModule(target, SCREEN_TARGET_PREFIX, this.getDefaultScreenModule());
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.setDefaultLayoutModule(config.getChild("defaultLayoutModule").getValue("defaultLayoutModule"));
        this.setDefaultNavigationModule(config.getChild("defaultLayoutModule").getValue("defaultLayoutModule"));
        this.setDefaultScreenModule(config.getChild("defaultLayoutModule").getValue("defaultLayoutModule"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

