/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit.resolver;

import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.collections.FastArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.summit.AbstractSummitComponent;
import org.apache.plexus.summit.module.Module;
import org.apache.plexus.summit.resolver.Resolution;
import org.apache.plexus.summit.resolver.Resolver;
import org.apache.plexus.summit.resolver.ResolverUtils;
import org.apache.plexus.summit.view.DefaultView;
import org.apache.plexus.summit.view.View;

public abstract class AbstractResolver
extends AbstractSummitComponent
implements Resolver,
Configurable,
ThreadSafe {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$resolver$AbstractResolver == null ? (class$org$apache$plexus$summit$resolver$AbstractResolver = AbstractResolver.class$("org.apache.plexus.summit.resolver.AbstractResolver")) : class$org$apache$plexus$summit$resolver$AbstractResolver));
    private static final String ERROR_VIEW_KEY = "errorView";
    private List modulePackages = new FastArrayList();
    private StringBuffer modulePackagesNames = new StringBuffer();
    private String errorView;
    private String defaultBaseName;
    private String defaultViewExtension;
    static /* synthetic */ Class class$org$apache$plexus$summit$resolver$AbstractResolver;

    public void configure(Configuration config) throws ConfigurationException {
        this.setErrorView(config.getChild(ERROR_VIEW_KEY).getValue());
        this.setDefaultBaseName(config.getChild("defaultBaseName").getValue());
        this.setDefaultViewExtension(config.getChild("defaultViewExtension").getValue());
        Configuration[] packages = config.getChild("modulePackages").getChildren();
        if (packages == null || packages.length == 0) {
            this.addModulePackage("");
        } else {
            int i = 0;
            while (i < packages.length) {
                log.info((Object)("Adding package " + packages[i].getValue()));
                this.addModulePackage(packages[i].getValue());
                ++i;
            }
        }
    }

    protected void setErrorView(String errorView) {
        this.errorView = errorView;
    }

    public String getErrorView() {
        return this.errorView;
    }

    protected void setDefaultBaseName(String defaultBaseName) {
        this.defaultBaseName = defaultBaseName;
    }

    public String getDefaultBaseName() {
        return this.defaultBaseName;
    }

    protected void setDefaultViewExtension(String defaultViewExtension) {
        this.defaultViewExtension = defaultViewExtension;
    }

    public String getDefaultViewExtension() {
        return this.defaultViewExtension;
    }

    protected void setModulePackages(List modulePackages) {
        this.modulePackages = modulePackages;
    }

    public List getModulePackages() {
        return this.modulePackages;
    }

    protected void addModulePackage(String modulePackage) {
        this.modulePackages.add(modulePackage);
        this.modulePackagesNames.append(modulePackage).append("\n");
    }

    protected View getView(String target) throws Exception {
        return this.getView(target, null, null);
    }

    protected View getView(String target, String targetPrefix) throws Exception {
        return this.getView(target, targetPrefix, null);
    }

    protected View getView(String target, String targetPrefix, String defaultView) throws Exception {
        List possibleViews = this.getPossibleViews(target, targetPrefix);
        if (defaultView != null && defaultView.length() > 0) {
            possibleViews.add(defaultView);
        }
        Iterator i = possibleViews.iterator();
        while (i.hasNext()) {
            String view = (String)i.next();
            log.info((Object)("Looking for view: " + view));
            if (this.getApplicationView() == null || !this.getApplicationView().viewExists(view)) continue;
            log.info((Object)("Found view: " + view));
            return new DefaultView(view);
        }
        return null;
    }

    protected List getPossibleViews(String target, String targetPrefix) throws Exception {
        FastArrayList views = new FastArrayList();
        List possibleViews = ResolverUtils.getPossibleViews(target, this.getDefaultBaseName());
        Iterator i = possibleViews.iterator();
        while (i.hasNext()) {
            String possibleView = (String)i.next();
            String view = targetPrefix != null && targetPrefix.length() > 0 ? targetPrefix + "/" + possibleView : possibleView;
            view = view + "." + this.getDefaultViewExtension();
            views.add((Object)view);
        }
        return views;
    }

    public void clearModulePackages() {
        int size = this.modulePackages.size();
        int i = 0;
        while (i < size) {
            this.modulePackages.remove(0);
            ++i;
        }
    }

    protected Module getModule(String target) throws Exception {
        return this.getModule(target, null, null);
    }

    protected Module getModule(String target, String targetPrefix) throws Exception {
        return this.getModule(target, targetPrefix, null);
    }

    protected Module getModule(String target, String targetPrefix, String defaultModule) throws Exception {
        Module module = null;
        List possibleModules = this.getPossibleModules(target, targetPrefix);
        if (defaultModule != null && defaultModule.length() > 0) {
            possibleModules.add(defaultModule);
        }
        Iterator i = possibleModules.iterator();
        while (i.hasNext()) {
            String moduleClass = (String)i.next();
            try {
                log.debug((Object)("[Resolver] Looking for " + moduleClass));
                module = (Module)Class.forName(moduleClass).newInstance();
                log.debug((Object)("[Resolver] " + target + " => " + moduleClass));
                break;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return module;
    }

    protected List getPossibleModules(String target, String targetPrefix) throws Exception {
        FastArrayList modules = new FastArrayList();
        List moduleSuffixes = ResolverUtils.getPossibleModuleSuffixes(target, this.getDefaultBaseName());
        Iterator i = this.modulePackages.iterator();
        while (i.hasNext()) {
            String modulePackage = (String)i.next();
            Iterator j = moduleSuffixes.iterator();
            while (j.hasNext()) {
                String module = targetPrefix != null && targetPrefix.length() > 0 ? modulePackage + "." + targetPrefix + "." + j.next() : modulePackage + "." + j.next();
                modules.add((Object)module);
            }
        }
        return modules;
    }

    public String getDefaultView() {
        return this.getDefaultBaseName() + this.getDefaultViewExtension();
    }

    public abstract Resolution resolve(String var1) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

