/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit.renderer;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.summit.exception.SummitException;
import org.apache.plexus.summit.renderer.AbstractRenderer;
import org.apache.plexus.summit.renderer.VelocityContextAdapter;
import org.apache.plexus.summit.rundata.RunData;
import org.apache.plexus.summit.view.ViewContext;
import org.apache.plexus.velocity.VelocityComponent;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;

public class VelocityRenderer
extends AbstractRenderer
implements Initializable,
Configurable,
ThreadSafe {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$renderer$VelocityRenderer == null ? (class$org$apache$plexus$summit$renderer$VelocityRenderer = VelocityRenderer.class$("org.apache.plexus.summit.renderer.VelocityRenderer")) : class$org$apache$plexus$summit$renderer$VelocityRenderer));
    private String encoding = "ISO-8859-1";
    private VelocityComponent velocity;
    private Configuration velocityConfiguration;
    static /* synthetic */ Class class$org$apache$plexus$summit$renderer$VelocityRenderer;

    public void initialize() throws Exception {
        try {
            this.velocity = (VelocityComponent)this.getServiceBroker().lookup(VelocityComponent.ROLE, this.velocityConfiguration);
        }
        catch (ServiceException e) {
            log.error((Object)"Error retrieving the velocity component!", (Throwable)e);
            throw new ConfigurationException("Error retrieving the velocity component!", (Throwable)e);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.velocityConfiguration = this.createConfiguration(config);
    }

    private Configuration createConfiguration(Configuration rendererConfiguration) throws ConfigurationException {
        DefaultConfiguration configuration = new DefaultConfiguration("configuration", "");
        DefaultConfiguration properties = new DefaultConfiguration("properties", "");
        configuration.addChild((Configuration)properties);
        Configuration[] propertyElements = rendererConfiguration.getChild("properties").getChildren("property");
        int i = 0;
        while (i < propertyElements.length) {
            String property = propertyElements[i].getAttribute("name");
            String value = propertyElements[i].getAttribute("value");
            properties.addChild((Configuration)this.createProperty(property, value));
            ++i;
        }
        return configuration;
    }

    private DefaultConfiguration createProperty(String name, String value) {
        DefaultConfiguration d = new DefaultConfiguration("property", "");
        d.setAttribute("name", name);
        d.setAttribute("value", value);
        return d;
    }

    public String render(RunData data, String view) throws SummitException, Exception {
        StringWriter writer = new StringWriter();
        this.render(data, view, writer);
        return writer.toString();
    }

    /*
     * Loose catch block
     */
    public void render(RunData data, String view, Writer writer) throws SummitException, Exception {
        block12: {
            log.info((Object)("Rendering template: " + view));
            ViewContext viewContext = (ViewContext)data.getMap().get("viewContext");
            VelocityContextAdapter vca = new VelocityContextAdapter(viewContext);
            if (!this.velocity.templateExists(view)) {
                log.error((Object)("Template " + view + " does note exist!"));
                throw new Exception("Template " + view + " does note exist!");
            }
            Template template = this.velocity.getTemplate(view);
            template.merge((Context)vca, writer);
            Object var8_8 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    log.error((Object)"Error rendering template: ", (Throwable)e);
                    Object var8_9 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public boolean viewExists(String view) {
        return this.velocity.templateExists(view);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

