/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit.pipeline;

import java.io.IOException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.summit.AbstractSummitComponent;
import org.apache.plexus.summit.exception.SummitException;
import org.apache.plexus.summit.pipeline.Pipeline;
import org.apache.plexus.summit.pipeline.valve.Valve;
import org.apache.plexus.summit.pipeline.valve.ValveContext;
import org.apache.plexus.summit.rundata.RunData;

public class SummitPipeline
extends AbstractSummitComponent
implements Pipeline,
ValveContext,
Initializable,
Configurable,
ThreadSafe {
    private Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$pipeline$SummitPipeline == null ? (class$org$apache$plexus$summit$pipeline$SummitPipeline = SummitPipeline.class$("org.apache.plexus.summit.pipeline.SummitPipeline")) : class$org$apache$plexus$summit$pipeline$SummitPipeline));
    protected String name;
    protected Valve[] valves = new Valve[0];
    protected ThreadLocal state = new ThreadLocal();
    private Configuration configuration;
    static /* synthetic */ Class class$org$apache$plexus$summit$pipeline$SummitPipeline;

    public void initialize() throws Exception {
        this.setName(this.configuration.getChild("name").getValue());
        Configuration[] descriptors = this.configuration.getChild("valveDescriptors").getChildren();
        int i = 0;
        while (i < descriptors.length) {
            String className = descriptors[i].getChild("className").getValue();
            this.log.info((Object)("Adding Valve: " + className));
            Valve valve = (Valve)Class.forName(className).newInstance();
            this.addValve(valve);
            ++i;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (valveArray) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
        }
    }

    public Valve[] getValves() {
        Valve[] valveArray = this.valves;
        synchronized (valveArray) {
            Valve[] results = new Valve[this.valves.length];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            Valve[] valveArray2 = results;
            return valveArray2;
        }
    }

    public void removeValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (valveArray) {
            int index = -1;
            int i = 0;
            while (i < this.valves.length) {
                if (valve == this.valves[i]) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index < 0) {
                return;
            }
            Valve[] results = new Valve[this.valves.length - 1];
            int n = 0;
            int i2 = 0;
            while (i2 < this.valves.length) {
                if (i2 != index) {
                    results[n++] = this.valves[i2];
                }
                ++i2;
            }
            this.valves = results;
        }
    }

    public void invoke(RunData data) throws SummitException, IOException {
        this.state.set(new Integer(0));
        this.invokeNext(data);
    }

    public void invokeNext(RunData data) throws SummitException, IOException {
        Integer current = (Integer)this.state.get();
        int subscript = current;
        if (subscript < this.valves.length) {
            this.state.set(new Integer(subscript + 1));
            this.valves[subscript].invoke(data, this);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

