/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.configuration.PlexusConfigurationHelper;
import org.apache.plexus.servlet.PlexusServlet;
import org.apache.plexus.summit.SummitEnvironment;
import org.apache.plexus.summit.SummitView;
import org.apache.plexus.summit.exception.SummitException;
import org.apache.plexus.summit.rundata.RunData;
import org.apache.plexus.summit.rundata.RunDataFactory;

public class Summit
extends PlexusServlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$Summit == null ? (class$org$apache$plexus$summit$Summit = Summit.class$("org.apache.plexus.summit.Summit")) : class$org$apache$plexus$summit$Summit));
    private static boolean firstDoGet = true;
    private static Configuration configuration;
    private static SummitEnvironment turbineEnvironment;
    private static Map applicationViews;
    private static RunDataFactory rundataFactory;
    private static String defaultApplicationView;
    static /* synthetic */ Class class$org$apache$plexus$summit$Summit;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            turbineEnvironment = (SummitEnvironment)this.getServiceBroker().lookup(SummitEnvironment.ROLE);
            Summit.configure(config);
            this.initialize();
        }
        catch (Exception e) {
            System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
            log.info((Object)("Initialization failed: " + ExceptionUtils.getStackTrace((Throwable)e)));
            return;
        }
        log.info((Object)"Initialization complete, Ready to service requests.");
    }

    public static synchronized void configure(ServletConfig config) throws Exception {
        log.info((Object)"Starting to configure Summit.");
        try {
            HashMap<String, String> initParameters = new HashMap<String, String>();
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = config.getInitParameter(name);
                initParameters.put(name, value);
            }
            turbineEnvironment.setInitParameters(initParameters);
            turbineEnvironment.setServletConfig(config);
            String configurationInitParameter = (String)initParameters.get("configuration");
            File configuration = new File(config.getServletContext().getRealPath(""), configurationInitParameter);
            Summit.setConfiguration(PlexusConfigurationHelper.build((String)configuration.getAbsolutePath()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new SummitException("Configure exception!", e);
        }
        log.info((Object)"Finished configuring Summit.");
    }

    public void initialize() throws Exception {
        log.info((Object)"Starting to initialize Summit.");
        rundataFactory = new RunDataFactory();
        applicationViews = new HashMap();
        Configuration[] views = configuration.getChild("applicationViews").getChildren();
        int i = 0;
        while (i < views.length) {
            String viewId = views[i].getValue();
            SummitView view = (SummitView)this.getServiceBroker().lookup(SummitView.ROLE, viewId);
            applicationViews.put(view.getId(), view);
            defaultApplicationView = viewId;
            ++i;
        }
        log.info((Object)"Finished initializing Turbine.");
    }

    public final void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        RunData data = null;
        try {
            SummitView applicationView = (SummitView)applicationViews.get(defaultApplicationView);
            data = rundataFactory.getRunData(req, res, turbineEnvironment, applicationView);
            this.initialize(data);
            applicationView.invokePipeline(data);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void initialize(RunData data) {
        if (firstDoGet) {
            Class clazz = class$org$apache$plexus$summit$Summit == null ? (class$org$apache$plexus$summit$Summit = Summit.class$("org.apache.plexus.summit.Summit")) : class$org$apache$plexus$summit$Summit;
            synchronized (clazz) {
                if (firstDoGet) {
                    Summit.saveServletInfo(data);
                    firstDoGet = false;
                }
            }
        }
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public final void destroy() {
        log.info((Object)"Done shutting down!");
    }

    public final String getServletInfo() {
        return "Turbine Servlet @VERSION@";
    }

    public static void setConfiguration(Configuration c) {
        configuration = c;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static void saveServletInfo(RunData data) {
        turbineEnvironment.setServerName(data.getRequest().getServerName());
        turbineEnvironment.setServerPort(new Integer(data.getRequest().getServerPort()).toString());
        turbineEnvironment.setServerScheme(data.getRequest().getScheme());
        turbineEnvironment.setScriptName(data.getRequest().getServletPath());
    }

    public static SummitEnvironment getSummitEnvironment() {
        return turbineEnvironment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

