/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.summit;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.plexus.context.DefaultPlexusContext;
import org.apache.plexus.context.PlexusContext;
import org.apache.plexus.service.PlexusServiceBroker;
import org.apache.plexus.service.ServiceBroker;
import org.apache.plexus.service.Serviceable;
import org.apache.plexus.summit.SummitEnvironment;
import org.apache.plexus.summit.SummitView;
import org.apache.plexus.summit.display.Display;
import org.apache.plexus.summit.exception.ExceptionHandler;
import org.apache.plexus.summit.exception.SummitException;
import org.apache.plexus.summit.pipeline.Pipeline;
import org.apache.plexus.summit.renderer.Renderer;
import org.apache.plexus.summit.resolver.Resolution;
import org.apache.plexus.summit.resolver.Resolver;
import org.apache.plexus.summit.rundata.RunData;

public class DefaultSummitView
extends PlexusServiceBroker
implements SummitView,
Serviceable {
    private Log log = LogFactory.getLog((Class)(class$org$apache$plexus$summit$DefaultSummitView == null ? (class$org$apache$plexus$summit$DefaultSummitView = DefaultSummitView.class$("org.apache.plexus.summit.DefaultSummitView")) : class$org$apache$plexus$summit$DefaultSummitView));
    private String id;
    private String name;
    private String applicationRoot;
    private SummitEnvironment turbineEnvironment;
    private ExceptionHandler exceptionHandler;
    private String templatePath;
    private String defaultTemplate;
    private String errorView;
    private String runDataClass;
    private Configuration configuration;
    private ServiceBroker broker;
    static /* synthetic */ Class class$org$apache$plexus$summit$DefaultSummitView;

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public void contextualize(PlexusContext context) throws ContextException {
        super.contextualize(context);
        DefaultPlexusContext summitContext = new DefaultPlexusContext((Context)context);
        summitContext.put((Object)"summit:view", (Object)this);
        this.setContainerContext((PlexusContext)summitContext);
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.id = config.getChild("id").getValue();
        this.name = config.getChild("name").getValue();
        this.runDataClass = config.getChild("runDataClass").getValue();
        this.configuration = config;
    }

    public void service(ServiceBroker broker) throws ServiceException {
        this.broker = broker;
    }

    public void initialize() throws Exception {
        try {
            super.initialize();
            this.log.info((Object)("Initializing SummitView " + this.getId()));
            this.setSummitEnvironment((SummitEnvironment)this.broker.lookup(SummitEnvironment.ROLE));
            this.createExceptionHandler();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error((Object)e);
            throw new SummitException("View initialization error!", e);
        }
    }

    public void invokePipeline(RunData data) throws IOException, SummitException {
        try {
            Pipeline pipeline = (Pipeline)this.lookup(Pipeline.ROLE);
            pipeline.invoke(data);
        }
        catch (ServiceException e) {
            this.log.error((Object)e);
            throw new SummitException("Could not get a Pipeline", e);
        }
    }

    public Resolution resolve(String view) throws Exception {
        this.log.debug((Object)"Resolving target!!");
        Resolver resolver = (Resolver)this.lookup(Resolver.ROLE);
        return resolver.resolve(view);
    }

    public String render(RunData data, String view) throws Exception {
        Renderer renderer = (Renderer)this.lookup(Renderer.ROLE);
        return renderer.render(data, view);
    }

    public void render(RunData data, String view, Writer writer) throws Exception {
        Renderer renderer = (Renderer)this.lookup(Renderer.ROLE);
        renderer.render(data, view, writer);
    }

    public boolean viewExists(String view) throws Exception {
        Renderer renderer = (Renderer)this.lookup(Renderer.ROLE);
        return renderer.viewExists(view);
    }

    public void display(RunData data, String view) throws Exception {
        this.log.debug((Object)"Displaying view!");
        Display display = (Display)this.lookup(Display.ROLE);
        display.render(data);
    }

    private void createExceptionHandler() throws Exception {
        String clazz = this.configuration.getChild("exceptionHandler").getValue();
        this.log.info((Object)("Creating exception handler: " + clazz));
        this.setExceptionHandler((ExceptionHandler)Class.forName(clazz).newInstance());
    }

    private final void handleException(RunData data, HttpServletRequest req, HttpServletResponse res, Throwable t) throws ServletException {
        this.log.error((Object)("handleException: " + t.getMessage()));
        this.log.error((Object)t);
        try {
            this.exceptionHandler.handleException(data, t);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    public String getRealPath(String path) {
        return this.getApplicationRoot() + '/' + path;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setSummitEnvironment(SummitEnvironment turbineEnvironment) {
        this.turbineEnvironment = turbineEnvironment;
    }

    public SummitEnvironment getSummitEnvironment() {
        return this.turbineEnvironment;
    }

    public void setRunDataClass(String runDataClass) {
        this.runDataClass = runDataClass;
    }

    public String getRunDataClass() {
        return this.runDataClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

