/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.validation;

import org.apache.oro.text.perl.Perl5Util;
import org.codehaus.plexus.formica.validation.AbstractValidator;

public class EmailValidator
extends AbstractValidator {
    private static String SPECIAL_CHARS = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
    private static String VALID_CHARS = "[^\\s" + SPECIAL_CHARS + "]";
    private static String QUOTED_USER = "(\"[^\"]*\")";
    private static String ATOM = VALID_CHARS + '+';
    private static String WORD = "(" + ATOM + "|" + QUOTED_USER + ")";
    private static String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static String EMAIL_PATTERN = "/^(.+)@(.+)$/";
    private static String IP_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static String USER_PATTERN = "/^" + WORD + "(\\." + WORD + ")*$/";
    private static String DOMAIN_PATTERN = "/^" + ATOM + "(\\." + ATOM + ")*$/";
    private static String ATOM_PATTERN = "/(" + ATOM + ")/";

    public boolean validate(String email) {
        if (email == null) {
            return false;
        }
        Perl5Util matchAsciiPat = new Perl5Util();
        if (!matchAsciiPat.match(LEGAL_ASCII_PATTERN, email)) {
            return false;
        }
        Perl5Util emailMatcher = new Perl5Util();
        if (!emailMatcher.match(EMAIL_PATTERN, email)) {
            return false;
        }
        if (email.endsWith(".")) {
            return false;
        }
        if (!this.isValidUser(emailMatcher.group(1))) {
            return false;
        }
        return this.isValidDomain(emailMatcher.group(2));
    }

    protected boolean isValidDomain(String domain) {
        boolean symbolic = false;
        Perl5Util ipAddressMatcher = new Perl5Util();
        if (ipAddressMatcher.match(IP_DOMAIN_PATTERN, domain)) {
            if (!this.isValidIpAddress(ipAddressMatcher)) {
                return false;
            }
        } else {
            Perl5Util domainMatcher = new Perl5Util();
            symbolic = domainMatcher.match(DOMAIN_PATTERN, domain);
        }
        if (symbolic) {
            return this.isValidSymbolicDomain(domain);
        }
        return false;
    }

    protected boolean isValidUser(String user) {
        Perl5Util userMatcher = new Perl5Util();
        return userMatcher.match(USER_PATTERN, user);
    }

    protected boolean isValidIpAddress(Perl5Util ipAddressMatcher) {
        for (int i = 1; i <= 4; ++i) {
            int iIpSegment;
            String ipSegment = ipAddressMatcher.group(i);
            if (ipSegment == null || ipSegment.length() <= 0) {
                return false;
            }
            try {
                iIpSegment = Integer.parseInt(ipSegment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (iIpSegment <= 255) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidSymbolicDomain(String domain) {
        String[] domainSegment = new String[10];
        boolean match = true;
        int i = 0;
        Perl5Util atomMatcher = new Perl5Util();
        while (match) {
            match = atomMatcher.match(ATOM_PATTERN, domain);
            if (!match) continue;
            domainSegment[i] = atomMatcher.group(1);
            int l = domainSegment[i].length() + 1;
            domain = l >= domain.length() ? "" : domain.substring(l);
            ++i;
        }
        int len = i;
        if (domainSegment[len - 1].length() < 2 || domainSegment[len - 1].length() > 4) {
            return false;
        }
        return len >= 2;
    }
}

