/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.validation;

import org.codehaus.plexus.formica.validation.AbstractValidator;

public class CreditCardValidator
extends AbstractValidator {
    private static String AMEX_PREFIX = "34,37,";
    private static String VISA_PREFIX = "4";
    private static String MASTERCARD_PREFIX = "51,52,53,54,55,";
    private static String DISCOVER_PREFIX = "6011";

    public boolean validate(String value) {
        return this.validateCreditCardLuhnCheck(value) && this.validateCreditCardPrefixCheck(value);
    }

    protected boolean validateCreditCardLuhnCheck(String cardNumber) {
        int digits = cardNumber.length();
        int oddoeven = digits & 1;
        long sum = 0L;
        for (int count = 0; count < digits; ++count) {
            int digit;
            try {
                digit = Integer.parseInt(String.valueOf(cardNumber.charAt(count)));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if ((count & 1 ^ oddoeven) == 0 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += (long)digit;
        }
        if (sum == 0L) {
            return false;
        }
        return sum % 10L == 0L;
    }

    protected boolean validateCreditCardPrefixCheck(String cardNumber) {
        int length = cardNumber.length();
        if (length < 13) {
            return false;
        }
        int cardType = 0;
        String prefix2 = cardNumber.substring(0, 2) + ",";
        if (AMEX_PREFIX.indexOf(prefix2) != -1) {
            cardType = 3;
        }
        if (cardNumber.substring(0, 1).equals(VISA_PREFIX)) {
            cardType = 4;
        }
        if (MASTERCARD_PREFIX.indexOf(prefix2) != -1) {
            cardType = 5;
        }
        if (cardNumber.substring(0, 4).equals(DISCOVER_PREFIX)) {
            cardType = 6;
        }
        if (cardType == 3 && length == 15) {
            return true;
        }
        if (cardType == 4 && (length == 13 || length == 16)) {
            return true;
        }
        if (cardType == 5 && length == 16) {
            return true;
        }
        return cardType == 6 && length == 16;
    }
}

