package com.particle.mpc.utils

import com.particle.mpc.data.ServerError
import com.particle.mpc.data.ServerException

/**
 * Created by chaichuanfa on 2023/5/19
 */
object ServerErrorHandler {

    fun parse(data: String): ServerError? {
        try {
            val serverError = JSON.parse<ServerError>(data)
            return if (serverError.code != null && serverError.code != 0 && !serverError.message.isNullOrEmpty()) {
                serverError
            } else {
                null
            }
        } catch (e: Exception) {
           return  null
        }
    }

    fun checkAndThrow(data: String) {
        val serverError = parse(data)
        if (serverError != null) {
            throw getException(serverError)
        }
    }

    fun getException(error: ServerError): ServerException {
        return ServerException(error.message, error.code, error.path, error.extra)
    }

    fun throwException(error: ServerError): ServerException {
        throw ServerException(error.message, error.code, error.path, error.extra)
    }


}