package com.particle.mpc.utils

import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken

/**
 * Created by chaichuanfa on 2023/5/12
 */
val JSON: Gson = GsonBuilder().disableHtmlEscaping().create()

inline fun <reified T> Gson.parse(json: String): T {
    return fromJson<T>(json, object : TypeToken<T>() {}.type)
}

inline fun <reified T> Gson.parse(json: JsonElement): T {
    return fromJson<T>(json, object : TypeToken<T>() {}.type)
}

fun Gson.stringify(obj: Any): String {
    return toJson(obj)
}