package com.particle.mpc.data

import androidx.annotation.Keep
import com.google.gson.JsonElement
import java.io.IOException

/**
 * Created by chaichuanfa on 2023/5/19
 */
@Keep
data class ServerException(override val message: String, val code: Int, val path: String?, val extra: JsonElement?) :
    IOException("$message, code: $code, extra: $extra, path: $path") {

    fun getExceptionMessage(): String {
        return "$message ${extra ?: ""} "
    }
}

@Keep
class RPCException(message: String, code: Int) :
    Exception("RPC Error, code: ${code}, message: $message")