package com.particle.mpc.data

import androidx.annotation.Keep
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName

/**
 * Created by chaichuanfa on 2023/5/12
 */
@Keep
data class EdDsaData(
    @SerializedName("id") val id: String,
    @SerializedName("key_agg") val keyAgg: String,
    @SerializedName("key_pair") val keyPair: String
)

@Keep
data class EdDsaDataBackup(
    @SerializedName("id") val id: String,
    @SerializedName("keyAgg") val keyAgg: JsonObject,
    @SerializedName("keyPair") val keyPair: JsonObject
)

@Keep
data class KeyAgg(val apk: ByteData)

@Keep
data class ByteData(@SerializedName("bytes_str") val bytesStr: String)


@Keep
data class EdDsaSign(@SerializedName("R") val r: ByteData, val s: String)