package com.particle.mpc;

import androidx.annotation.Keep;

/**
 * Created by chaichuanfa on 2023/5/11
 */
@Keep
public class MPCNative {

    static {
        System.loadLibrary("thresh_sig_wasm");
    }

    public static native String hashPassword(String password, String salt);

    public static native String decrypt(String plaintext, String key);

    public static native String encrypt(String ciphertext, String key);

    public static native String eddsaKeygen(String endpoint, String auth_params);

    public static native String eddsaSign(String endpoint, String auth_params, String message,
            String key);

    public static native String ecdsaKeygen(String endpoint, String auth_params);

    public static native String ecdsaSign(String endpoint, String auth_params, String message,
            String key, String uniq_sign);

    public static native String ecdsaSignTx(String endpoint, String auth_params, String tx_data,
            String key);

    public static native String ecdsaRotate(String endpoint, String auth_params, String key);

    public static native String ecdsaPub(String key);

}
