package com.particle.mpc

import com.particle.mpc.utils.ServerErrorHandler

/**
 * Created by chaichuanfa on 2023/5/11
 */
object Helper {

    fun generateKey(password: String, uuid: String): String {
        val result = MPCNative.hashPassword(password, uuid)
        ServerErrorHandler.checkAndThrow(result)
        return result
    }

    fun decryptData(ciphertext: String, key: String): String {
        val result = MPCNative.decrypt(ciphertext, key)
        ServerErrorHandler.checkAndThrow(result)
        return result
    }

    fun encryptData(plaintext: String, key: String): String {
        val result = MPCNative.encrypt(plaintext, key)
        ServerErrorHandler.checkAndThrow(result)
        return result
    }
}