package com.particle.api.service.data

import com.particle.api.infrastructure.net.data.AbiEncodeFunction
import com.particle.base.model.PrefixedHexString

class ContractParams {
    var contractAddress: PrefixedHexString = ""
    var method: String = ""
    var params: List<Any> = mutableListOf()
    var abiJsonString: String? = ""

    companion object {
        fun erc20Transfer(contractAddress: String, to: String, amount: String): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = AbiEncodeFunction.erc20Transfer.value
            config.params = mutableListOf(to, amount)
            return config
        }

        fun erc20Approve(contractAddress: String, spender: String, amount: String): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = AbiEncodeFunction.erc20Approve.value
            config.params = mutableListOf(spender, amount)
            return config
        }

        fun erc20TransferFrom(
            contractAddress: String,
            from: String,
            to: String,
            amount: String
        ): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = AbiEncodeFunction.erc20TransferFrom.value
            config.params = mutableListOf(from, to, amount)
            return config
        }

        fun erc721SafeTransferFrom(
            contractAddress: String,
            from: String,
            to: String,
            tokenId: String
        ): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = AbiEncodeFunction.erc721SafeTransferFrom.value
            config.params = mutableListOf(from, to, tokenId)
            return config
        }

        fun erc1155SafeTransferFrom(
            contractAddress: String,
            from: String,
            to: String,
            id: String,
            amount: String,
            data: String
        ): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = AbiEncodeFunction.erc1155SafeTransferFrom.value
            config.params = mutableListOf(from, to, id, amount, data)
            return config
        }

        fun customAbiEncodeFunctionCall(
            contractAddress: String,
            methodName: String,
            params: List<Any>,
            abiJsonString: String? = ""
        ): ContractParams {
            val config = ContractParams()
            config.contractAddress = contractAddress
            config.method = "custom_$methodName"
            config.params = params
            config.abiJsonString = abiJsonString
            return config
        }
    }
}