package com.particle.api.service

import android.text.TextUtils
import com.particle.api.infrastructure.db.table.SplToken
import com.particle.api.infrastructure.net.data.resp.SplTokenList
import com.particle.base.ParticleNetwork
import network.particle.chains.ChainInfo

internal object SplTokenService {

    val oosProcess = "?x-oss-process=image/resize,w_200,h_200,limit_0/circle,r_100/format,webp"

    suspend fun insertSplToken(allTokens: SplTokenList,chainInfo: ChainInfo?) {
        val splTokens = arrayListOf<SplToken>()
        for (t in allTokens.tokens) {
            var url = ""
            if (!TextUtils.isEmpty(t.logoURI)) {
                url = if (!isSvg(t.logoURI)) {
                    "${t.logoURI}${oosProcess}"
                } else {
                    t.logoURI
                }
            }
            val token = SplToken(
                chainInfo?.name?.lowercase() ?: ParticleNetwork.chainName,
                t.chainId,
                t.address,
                t.symbol,
                t.decimals,
                t.name,
                url
            )
            splTokens.add(token)
        }
        DBService.splTokenDao.insertAll(splTokens)
    }

    private fun isSvg(url: String): Boolean {
        return url.endsWith("svg")
    }
}