package com.particle.api.logic

import com.particle.api.evm
import com.particle.api.infrastructure.db.table.Rates
import com.particle.api.infrastructure.net.data.resp.RateResult
import com.particle.api.service.DBService
import com.particle.api.solana
import com.particle.base.ParticleNetwork
import com.particle.base.ParticleNetwork.getFiatCoin

object RatesLogic {
    suspend fun updateRates(address: String) {
        val allTokenInfo = DBService.tokenInfoDao.getAllDisplayed(
            address,
            ParticleNetwork.chainName,
            ParticleNetwork.chainId
        )
        val parmas1 = arrayListOf<String>()
        for (token in allTokenInfo) {
            parmas1.add(token.address)
        }
        val parmas2 = arrayListOf(ParticleNetwork.getFiatCoin().value)
        val erate =
            if (ParticleNetwork.isEvmChain()) {
                ParticleNetwork.evm.getPrice(
                    parmas1, parmas2
                )
            } else {
                ParticleNetwork.solana.getPrice(
                    parmas1, parmas2
                )
            }
        DBService.ratesDao.deleteAll(
            ParticleNetwork.chainName,
            ParticleNetwork.chainId
        )
        val result = erate.result
        val allRates = arrayListOf<Rates>()
        for (rt in result) {
            for (currency in rt.currencies) {
                allRates.add(
                    Rates(
                        ParticleNetwork.chainName,
                        ParticleNetwork.chainId,
                        rt.address,
                        currency.type,
                        currency.price,
                        currency.marketCap,
                        currency.`24hChange`,
                        currency.`24hVol`,
                        currency.lastUpdatedAt.toDouble()
                    )
                )
            }

        }
        if (allRates.size > 0) DBService.ratesDao.insertAll(allRates)
    }

    suspend fun getRate(addresses: List<String>): List<RateResult> {
        val parmas2 = arrayListOf(ParticleNetwork.getFiatCoin().value)
        val erate =
            if (ParticleNetwork.isEvmChain()) {
                ParticleNetwork.evm.getPrice(
                    addresses, parmas2
                )
            } else {
                ParticleNetwork.solana.getPrice(
                    addresses, parmas2
                )
            }
        return erate.result
    }
}