package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
@Keep
data class TransactionResp(
    val meta: Meta, val slot: Int, val transaction: TransactionInfo
)
@Keep
data class Meta(
    val err: Any,
    val fee: Int,
    val innerInstructions: List<Any>,
    val postBalances: List<Long>,
    val postTokenBalances: List<Any>,
    val preBalances: List<Long>,
    val preTokenBalances: List<Any>,
    val rewards: List<Any>,
    val status: MetaStatus
)
@Keep
data class TransactionInfo(
    val message: Message, val signatures: List<String>
)
@Keep
data class MetaStatus(
    val Ok: Any
)
@Keep
data class Message(
    val accountKeys: List<String>,
    val header: Header,
    val instructions: List<Instruction>,
    val recentBlockhash: String
)
@Keep
data class Header(
    val numReadonlySignedAccounts: Int,
    val numReadonlyUnsignedAccounts: Int,
    val numRequiredSignatures: Int
)
@Keep
data class Instruction(
    val accounts: List<Int>, val `data`: String, val programIdIndex: Int
)