package com.particle.api.infrastructure.net.data.resp

import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.android.parcel.Parcelize

@Keep
data class TransResult(
    val blockTime: Long,
    val data: TransResultData,
    val lamportsChange: Long,
    val lamportsFee: Long,
    val signature: String,
    val status: String,
    val type: String,
)

@Keep
@Parcelize
data class TransResultData(
    val amountTransfered: Long?,
    val decimals: Int?,
    val image: String?,
    val lamportsTransfered: Long?,
    val mint: String?,
    val name: String?,
    val receiver: String?,
    val receiverAssociatedTokenAddress: String?,
    val sender: String?,
    val senderAssociatedTokenAddress: String?,
    val symbol: String?,
) : Parcelable