package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
import java.math.BigInteger
@Keep
data class TokenResult(
    val lamports: BigInteger,
    val native: BigInteger,
    val nfts: List<Nft>,
    val tokens: List<Token>
)
@Keep
data class Nft(
    val metadata: MetaData?,
    val data: NFTData?,
    val image: String?,
    val mint: String?,//solana
    val name: String,
    val symbol: String?,

    val isSemiFungible: Boolean?,
    val address: String?, //evm
    val tokenId: String?,
    val tokenBalance: Int?,
    val isScam:Boolean
)
@Keep
data class Token(
    val amount: BigInteger,
    val decimals: Int,
    val image: String,
    val mint: String,
    val address: String,
    val name: String,
    val symbol: String
)
@Keep
data class MetaData(
    val `data`: Data,
    val editionNonce: Int,
    val isMutable: Boolean,
    val key: Int,
    val mint: String,
    val primarySaleHappened: Boolean,
    val updateAuthority: String
)
@Keep
data class NFTData(
    val name: String?,
    val description: String?,
    val image: String?,
    val animation_url: String?,
    val owner: String?,
    val external_url: Any,
    val external_link: Any,

    val attributes: List<Attribute>?
)
@Keep
data class Data(
    val creators: List<Creator>,
    val name: String,
    val sellerFeeBasisPoints: Int,
    val symbol: String,
    val uri: String,
    val uriData: UriData
)
@Keep
data class Creator(
    val address: String,
    val share: Int,
    val verified: Boolean
)
@Keep
data class UriData(
    val animation_url: String,
    val attributes: List<Attribute>,
    val collection: Collection,
    val description: String,
    val image: String,
    val name: String,
    val properties: Properties,
    val seller_fee_basis_points: Int,
    val symbol: String,
    val external_url: String,
)
@Keep
data class Attribute(
    val trait_type: String,
    val value: String
)

data class Collection(
    val family: String,
    val name: String
)
@Keep
data class Properties(
    val category: String,
    val creators: List<CreatorX>,
    val files: List<File>
)
@Keep
data class CreatorX(
    val address: String,
    val share: Int
)
@Keep
data class File(
    val type: String,
    val uri: String
)