package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
import java.math.BigInteger
@Keep
data class TokenAccountsByDelegateResp(
    val context: SlotContext, val value: List<TokenAccountsByDelegateRespValue>
)

data class TokenAccountsByDelegateRespValue(
    val account: TokenAccountsByDelegateRespAccount, val pubkey: String
)
@Keep
data class TokenAccountsByDelegateRespAccount(
    val `data`: AccountData,
    val executable: Boolean,
    val lamports: BigInteger,
    val owner: String,
    val rentEpoch: BigInteger
)
@Keep
data class AccountData(
    val parsed: Parsed, val program: String, val space: Int
)
@Keep
data class Parsed(
    val info: ParsedInfo, val type: String
)
@Keep
data class ParsedInfo(
    val `delegate`: String,
    val delegatedAmount: DelegatedAmount,
    val isNative: Boolean,
    val mint: String,
    val owner: String,
    val state: String,
    val tokenAmount: TokenAmount
)
@Keep
data class DelegatedAmount(
    val amount: String, val decimals: Int, val uiAmount: Double, val uiAmountString: String
)
@Keep
data class TokenAmount(
    val amount: String, val decimals: Int, val uiAmount: Double, val uiAmountString: String
)