package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import java.math.BigInteger
@Keep
data class SOLRespValue(
    val amount: String,
    val decimals: Int,
    val uiAmount: BigInteger?,
    val uiAmountString: String
)
@Keep
data class SlotContext(
    val slot: BigInteger
)
@Keep
data class IdentityResp(
    val identity: String
)
@Keep
data class InflationGovernorResp(
    val foundation: Double,
    val foundationTerm: Int,
    val initial: Double,
    val taper: Double,
    val terminal: Double
)
@Keep
data class InflationRateResp(
    val epoch: BigInteger, val foundation: Double, val total: Double, val validator: Double
)
@Keep
data class InflationRewardResp(
    val amount: BigInteger,
    val effectiveSlot: BigInteger,
    val epoch: BigInteger,
    val postBalance: BigInteger,
    val commission: BigInteger?
)
@Keep
data class PerformanceSampleResp(
    val numSlots: BigInteger,
    val numTransactions: BigInteger,
    val samplePeriodSecs: BigInteger,
    val slot: BigInteger
)
@Keep
data class StakeActivationResp(
    val active: BigInteger,
    val inactive: BigInteger,
    val state: String
)
@Keep
data class StakeMinimumDelegationResp(
    val context: SlotContext,
    val value: BigInteger
)
@Keep
data class SolanaVersion(
    @SerializedName("solana-core")
    val solanaCore: String
)
@Keep
data class BlockhashResp(
    val context: SlotContext,
    val value: Boolean
)

