package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import java.math.BigInteger

@Keep
data class QuoteTrans(
    @SerializedName("isPartialSigned")
    val isPartialSigned: Boolean,
    @SerializedName("serialized")
    val serialized: String,
    @SerializedName("signers")
    val signers: List<Any>
)
@Keep
data class QuoteInfoSOL(
    @SerializedName("amount")
    val amount: BigInteger,
    @SerializedName("fees")
    val fees: QuoteFees,
    @SerializedName("inAmount")
    val inAmount: BigInteger,
    @SerializedName("marketInfos")
    val marketInfos: List<MarketInfo>,
    @SerializedName("otherAmountThreshold")
    val otherAmountThreshold: BigInteger,
    @SerializedName("outAmount")
    val outAmount: BigInteger,
    @SerializedName("outAmountWithSlippage")
    val outAmountWithSlippage: BigInteger,
    @SerializedName("priceImpactPct")
    val priceImpactPct: Double,
    @SerializedName("swapMode")
    val swapMode: String
)
@Keep
data class QuoteFees(
    @SerializedName("ataDeposits")
    val ataDeposits: List<BigInteger>,
    @SerializedName("minimumSOLForTransaction")
    val minimumSOLForTransaction: BigInteger?,
    @SerializedName("openOrdersDeposits")
    val openOrdersDeposits: List<Int>,
    @SerializedName("signatureFee")
    val signatureFee: Int,
    @SerializedName("totalFeeAndDeposits")
    val totalFeeAndDeposits: BigInteger
)
@Keep
data class MarketInfo(
    @SerializedName("id")
    val id: String,
    @SerializedName("inAmount")
    val inAmount: BigInteger,
    @SerializedName("inputMint")
    val inputMint: String,
    @SerializedName("label")
    val label: String,
    @SerializedName("lpFee")
    val lpFee: LpFee,
    @SerializedName("minInAmount")
    val minInAmount: BigInteger,
    @SerializedName("minOutAmount")
    val minOutAmount: BigInteger,
    @SerializedName("notEnoughLiquidity")
    val notEnoughLiquidity: Boolean,
    @SerializedName("outAmount")
    val outAmount: BigInteger,
    @SerializedName("outputMint")
    val outputMint: String,
    @SerializedName("platformFee")
    val platformFee: PlatformFee,
    @SerializedName("priceImpactPct")
    val priceImpactPct: Double
)
@Keep
data class LpFee(
    @SerializedName("amount")
    val amount: BigInteger,
    @SerializedName("mint")
    val mint: String,
    @SerializedName("pct")
    val pct: Double
)
@Keep
data class PlatformFee(
    @SerializedName("amount")
    val amount: BigInteger,
    @SerializedName("mint")
    val mint: String,
    @SerializedName("pct")
    val pct: Double
)