package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import java.math.BigInteger

@Keep
data class QuoteInfoEVM(
    @SerializedName("estimatedGas")
    val estimatedGas: String,
    @SerializedName("fromToken")
    val fromToken: FromToken,
    @SerializedName("fromTokenAmount")
    val fromTokenAmount: String,
    @SerializedName("toToken")
    val toToken: ToToken,
    @SerializedName("toTokenAmount")
    val toTokenAmount: String,
    @SerializedName("provider")
    val provider: String
)
@Keep
data class FromToken(
    @SerializedName("address")
    val address: String,
    @SerializedName("chainId")
    val chainId: Long,
    @SerializedName("decimals")
    val decimals: Int,
    @SerializedName("logoURI")
    val logoURI: String,
    @SerializedName("name")
    val name: String,
    @SerializedName("symbol")
    val symbol: String
)
@Keep
data class ToToken(
    @SerializedName("address")
    val address: String,
    @SerializedName("chainId")
    val chainId: Long,
    @SerializedName("decimals")
    val decimals: Int,
    @SerializedName("logoURI")
    val logoURI: String,
    @SerializedName("name")
    val name: String,
    @SerializedName("symbol")
    val symbol: String
)