package com.particle.api.infrastructure.net.data.resp

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.android.parcel.Parcelize
import kotlinx.parcelize.Parceler

@Keep
data class EvmTransResult(
    val chainId: String,
    val data: String?,
    val fees: String?,
    val from: String,
    val gasLimit: String?,
    val gasPrice: String?,
    val gasSpent: String?,
    val hash: String,
    val maxFeePerGas: String?,
    val maxPriorityFeePerGas: String?,
    val nonce: String?,
    val r: String?,
    val s: String?,
    val status: Int?,
    val timestamp: Long,
    val to: String,
    val type: Int?,
    val v: String?,
    val value: String,
    val deserializedData: DeserializedData?
)

@Keep
@Parcelize
data class DeserializedData(
    val type: String,
    val estimatedChanges: EstimatedChanges,
    val `data`: DeserializedDataData?,
    val platform: Platform?
) : Parcelable

@Keep
@Parcelize
data class DeserializedDataData(
    val from: String,
    val function: Function
) : Parcelable

@Parcelize
@Keep
data class EstimatedChanges(
    val natives: List<EstimatedChangesNative>,
    val nfts: List<EstimatedChangesNft>,
    val tokens: List<EstimatedChangesToken>
) : Parcelable

@Keep
@Parcelize
data class Platform(
    val icon: String,
    val name: String
) : Parcelable

@Keep
@Parcelize
data class Function(
    val displayName: String,
    val name: String,
    val params: List<Param>
) : Parcelable

@Keep
@Parcelize
class Param(
    val name: String,
    val type: String,
//    val value: Any
) : Parcelable {
//    companion object : Parceler<Param> {
//        override fun Param.write(parcel: Parcel, flags: Int) {
//            // Write name and type
//            parcel.writeString(name)
//            parcel.writeString(type)
//
//            // Write value based on its type
//            when (value) {
//                is String -> parcel.writeString(value)
//                is List<*> -> {
//                    // Assume the list contains only strings
//                    @Suppress("UNCHECKED_CAST")
//                    parcel.writeStringList(value as List<String>)
//                }
//                else -> throw IllegalArgumentException("Unsupported type: ${value.javaClass.simpleName}")
//            }
//        }
//
//        override fun create(parcel: Parcel): Param {
//            // Read name and type
//            val name = parcel.readString() ?: ""
//            val type = parcel.readString() ?: ""
//            val valueType = parcel.readString() ?: ""
//
//            // Read value based on its type
//            val value = when (valueType) {
//                is String -> parcel.readString() ?: ""
//                else -> {
//                    val stringList = ArrayList<String>()
//                    parcel.readStringList(stringList)
//                    stringList
//                }
//            }
//
//            return Param(name, type, value)
//        }
//    }
}

@Keep
@Parcelize
data class EstimatedChangesNative(
    val amountChange: String,
    val fromAddress: String
) : Parcelable

@Keep
@Parcelize
data class EstimatedChangesNft(
    val address: String,
    val amountChange: String,
    val fromAddress: String,
    val image: String,
    val name: String,
    val symbol: String,
    val tokenId: String
) : Parcelable

@Keep
@Parcelize
data class EstimatedChangesToken(
    val address: String,
    val amountChange: String,
    val decimals: Int,
    val fromAddress: String,
    val image: String,
    val name: String,
    val symbol: String,
    val toAddress: String?
) : Parcelable