package com.particle.api.infrastructure.net.data.resp

import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.android.parcel.Parcelize

@Keep
@Parcelize
data class EvmGasResult(
    val baseFee: String,
    val high: EvmGasInfo,
    val low: EvmGasInfo,
    val medium: EvmGasInfo
) : Parcelable

@Keep
@Parcelize
data class EvmGasInfo(
    val maxFeePerGas: String,
    val maxPriorityFeePerGas: String,
    val minWaitTime: Int,
    val maxWaitTime: Int,
    val gasLimit: Int?,
    val baseFee: String?
) : Parcelable
