package com.particle.api.infrastructure.net.data.resp

import androidx.annotation.Keep

@Keep
data class CompileSolidityResp(
    val code: String,
    val info: Info
)

@Keep
data class Info(
    val abiDefinition: List<AbiDefinition>,
    val compilerVersion: String,
    val developerDoc: DeveloperDoc,
    val language: String,
    val languageVersion: String,
    val source: String,
    val userDoc: UserDoc
)

@Keep
data class AbiDefinition(
    val constant: Boolean,
    val inputs: List<Input>,
    val name: String,
    val outputs: List<Output>,
    val type: String
)

@Keep
data class DeveloperDoc(
    val methods: Methods
)

@Keep
data class UserDoc(
    val methods: Methods
)

@Keep
data class Input(
    val name: String,
    val type: String
)

@Keep
data class Output(
    val name: String,
    val type: String
)

class Methods