package com.particle.api.infrastructure.net.data.resp

import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.parcelize.Parcelize
import java.math.BigInteger

@Keep
data class BridgeSupportedToken(
    val address: String,
    val decimals: Int,
    val name: String,
    val symbol: String,
    val logoURI: String,
    val chainId: Long,
    var amount: BigInteger = BigInteger.ZERO,
    var rate: Double? = null,
)

@Keep
data class BridgeGetQuoteResp(
    val estimatedGas: String,
    val fromAddress: String,
    val fromChainId: Long,
    val fromToken: BridgeGetQuoteToken,
    val fromTokenAmount: String,
    val toAddress: String,
    val toChainId: Long,
    val toToken: BridgeGetQuoteToken,
    val toTokenAmount: String,
    val tx: Tx
)

@Keep
@Parcelize
data class BridgeGetQuoteToken(
    val address: String,
    val chainId: Long,
    val decimals: Int,
    var logoURI: String,
    val name: String,
    val symbol: String
) : Parcelable

@Keep
@Parcelize
data class BridgeGetQuoteTx(
    val `data`: String,
    val to: String,
    val value: String
) : Parcelable

@Keep
@Parcelize
data class BridgeApproveResult(
    val approved: Boolean,
    val provider: String,
    val tx: Tx?
) : Parcelable

@Keep
@Parcelize
data class BridgeHistory(
    val createdAt: Long,
    val fromAddress: String,
    val fromChainId: Long,
    val fromToken: BridgeGetQuoteToken,
    val fromTokenAddress: String,
    val fromTokenAmount: String,
    val fromTransactionHash: String,
    val status: String,
    val toAddress: String,
    val toChainId: Long,
    val toToken: BridgeGetQuoteToken?,
    val toTokenAddress: String,
    val toTokenAmount: String?,
    val toTransactionHash: String?,
    val updatedAt: Long
) : Parcelable {
    companion object {
        val statusDone = "DONE"
        val statusPending = "PENDING"
    }

    fun isPending(): Boolean {
        return status.equals(statusPending, true)
    }

    fun isDone(): Boolean {
        return status.equals(statusDone, true)
    }
}

