package com.particle.api.infrastructure.net.data.req

import androidx.annotation.Keep
import java.math.BigInteger

@Keep
data class CommitmentInfo(
    val commitment: String?,
)

@Keep
data class EpochInfoReq(
    val commitment: String?,
    val minContextSlot: BigInteger?,
)

@Keep
data class FeeForMessageReq(
    val commitment: String?,
    val minContextSlot: BigInteger?,
)

@Keep
data class TransactionCountReq(
    val commitment: String?,
    val minContextSlot: BigInteger?,
)

@Keep
data class VoteAccountsReq(
    val commitment: String?,
    val votePubkey: String?,
    val keepUnstakedDelinquents: Boolean?,
    val delinquentSlotDistance: BigInteger?,
)

@Keep
data class InflationRewardReq(
    val commitment: String?,
    val epoch: BigInteger?,
    val minContextSlot: BigInteger?,
)

@Keep
data class BlockhashReq(
    val commitment: String?,
    val minContextSlot: BigInteger?,
)

@Keep
data class LargestAccountsReq(
    val commitment: String?, val filter: String?
)

@Keep
data class LatestBlockhashReq(
    val commitment: String?, val minContextSlot: BigInteger?
)

@Keep
data class LeaderScheduleReq(
    val commitment: String?, val identity: String?
)

@Keep
data class SupplyReq(
    val commitment: String?, val excludeNonCirculatingAccountsList: Boolean?
)

@Keep
data class SlotReq(
    val commitment: String?, val minContextSlot: BigInteger?
)

@Keep
data class TransactionReq(
    val encoding: String?, val commitment: String?, val maxSupportedTransactionVersion: Int?
)

@Keep
data class TokenAccountsByDelegateReq(
    val commitment: String?, val encoding: String?, val dataSlice: DataSliceReq?, val minContextSlot: BigInteger?
)

@Keep
data class DataSliceReq(
    val offset: BigInteger, val length: BigInteger
)

@Keep
data class StakeActivationReq(
    val commitment: String?, val epoch: BigInteger?, val minContextSlot: BigInteger?
)

@Keep
data class SignatureStatusesReq(
    val searchTransactionHistory: Boolean
)

@Keep
data class SignaturesForAddressReq(
    val limit: Int?, val before: String?, val until: String?, val commitment: String?, val minContextSlot: BigInteger?
)
