package com.particle.api.infrastructure.net.data


import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName

@Keep
data class SerializeSOLTransReq(
    val sender: String,
    val receiver: String,
    val lamports: Long
)

@Keep
data class SerializeTokenTransReq(
    val sender: String,
    val receiver: String,
    val mint: String,
    val amount: Long
)

@Keep
data class TransOptBody(
    val limit: Int? = 1000,
    val before: String? = null,
    val until: String? = null,
    val commitment: String? = null,
)

@Keep
enum class SerializeTransactionParams(val value: String) {
    transferSol("transfer-sol"),
    transferToken("transfer-token")
}

@Keep
enum class ReqBodyMethod(var value: String) {
    //SOL
    enhancedGetTokensAndNFTs("enhancedGetTokensAndNFTs"),
    enhancedGetPrice("enhancedGetPrice"),
    enhancedGetTransactionsByAddress("enhancedGetTransactionsByAddress"),
    enhancedGetTokenTransactionsByAddress("enhancedGetTokenTransactionsByAddress"),
    enhancedSerializeTransaction("enhancedSerializeTransaction"),
    enhancedGetTokensByTokenAddresses("enhancedGetTokensByTokenAddresses"),
    swapGetQuote("SWAP_getQuote"),
    swapGetTransactions("SWAP_getTransactions"),

    getAccountInfo("getAccountInfo"),
    getBalance("getBalance"),
    getBlock("getBlock"),
    getBlockHeight("getBlockHeight"),
    getBlockProduction("getBlockProduction"),
    getBlockCommitment("getBlockCommitment"),
    getBlocks("getBlocks"),
    getBlocksWithLimit("getBlocksWithLimit"),
    getBlockTime("getBlockTime"),
    getClusterNodes("getClusterNodes"),
    getEpochInfo("getEpochInfo"),
    getEpochSchedule("getEpochSchedule"),
    getFeeForMessage("getFeeForMessage"),
    getFirstAvailableBlock("getFirstAvailableBlock"),
    getGenesisHash("getGenesisHash"),
    getHealth("getHealth"),
    getHighestSnapshotSlot("getHighestSnapshotSlot"),
    getIdentity("getIdentity"),
    getInflationGovernor("getInflationGovernor"),
    getInflationRate("getInflationRate"),
    getInflationReward("getInflationReward"),
    getLargestAccounts("getLargestAccounts"),
    getLatestBlockhash("getLatestBlockhash"),
    getLeaderSchedule("getLeaderSchedule"),
    getMaxRetransmitSlot("getMaxRetransmitSlot"),
    getMaxShredInsertSlot("getMaxShredInsertSlot"),
    getMinimumBalanceForRentExemption("getMinimumBalanceForRentExemption"),
    getMultipleAccounts("getMultipleAccounts"),
    getProgramAccounts("getProgramAccounts"),
    getRecentPerformanceSamples("getRecentPerformanceSamples"),
    getSignaturesForAddress("getSignaturesForAddress"),
    getSignatureStatuses("getSignatureStatuses"),
    getSlot("getSlot"),
    getSlotLeader("getSlotLeader"),
    getSlotLeaders("getSlotLeaders"),
    getStakeActivation("getStakeActivation"),
    getStakeMinimumDelegation("getStakeMinimumDelegation"),
    getSupply("getSupply"),
    getTokenAccountBalance("getTokenAccountBalance"),
    getTokenAccountsByDelegate("getTokenAccountsByDelegate"),
    getTokenAccountsByOwner("getTokenAccountsByOwner"),
    getTokenLargestAccounts("getTokenLargestAccounts"),
    getTokenSupply("getTokenSupply"),
    getTransaction("getTransaction"),
    getTransactionCount("getTransactionCount"),
    getVersion("getVersion"),
    getVoteAccounts("getVoteAccounts"),
    isBlockhashValid("isBlockhashValid"),
    minimumLedgerSlot("minimumLedgerSlot"),
    requestAirdrop("requestAirdrop"),
    sendTransaction("sendTransaction"),
    simulateTransaction("simulateTransaction"),
}

@Keep
data class ReqBody(
    val chainId: Long,
    val id: String,
    val jsonrpc: String = "2.0",
    val method: String,
    val params: List<Any?>? = null,
)

@Keep
data class RpcOutput<T>(
    @SerializedName("chainId")
    val chainId: Long,

    @SerializedName("jsonrpc")
    val jsonrpc: String,

    @SerializedName("id")
    val id: String,

    @SerializedName("result")
    val result: T,

    @SerializedName("error")
    val error: Error?,

    ) {
    fun isSuccess(): Boolean {
        return null == error
    }
}

@Keep
data class RpcOutputWithError<T, Error>(
    @SerializedName("chainId")
    val chainId: Long,

    @SerializedName("jsonrpc")
    val jsonrpc: String,

    @SerializedName("id")
    val id: String,

    @SerializedName("result")
    val result: T,

    @SerializedName("error")
    val error: Error?,

    )

@Keep
data class RPCError(
    @SerializedName("code")
    val code: Int,
    @SerializedName("data")
    val data: RPCErrorData?,
    @SerializedName("message")
    val message: String
)

@Keep
data class RPCErrorData(
    @SerializedName("extraMessage")
    val extraMessage: String?
)
