package com.particle.api.infrastructure.net.data

import androidx.annotation.Keep
import com.google.gson.Gson
import com.google.gson.annotations.SerializedName

@Keep
data class ServerError(val error: Error?)

@Keep
data class Error(
    @SerializedName("code")
    val code: Int,

    @SerializedName("message")
    val message: String,

    @SerializedName("data")
    val data: Any?,

    var reqUrl: String?,

    var reqBody:String?
){
    override fun toString(): String {
        return getErrorInfo()
    }


    fun getErrorInfo(): String {
        // 判断data的类型，如果是String则直接返回，否则转为JSON字符串
        val dataStr = when (data) {
            is String -> data
            else -> {
                try {
                    Gson().toJson(data)
                } catch (e: Exception) {
                    // 转换失败时，返回通用错误信息
                    "Invalid data format"
                }
            }
        }
        return "errorCode:${code}  errorMsg:${message}  $data $dataStr"
    }
}
