package com.particle.api.infrastructure.net.data

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
@Keep
data class RequestConfiguration(
    @SerializedName("commitment")
    val commitment: String? = null,
    @SerializedName("encoding")
    val encoding: String? = null,
    @SerializedName("dataSlice")
    val dataSlice: DataSlice? = null,
    @SerializedName("filters")
    val filters: List<Any>? = null,
    @SerializedName("limit")
    val limit: Int? = null,
    @SerializedName("before")
    val before: String? = null,
    @SerializedName("until")
    val until: String? = null
)
@Keep
enum class Encoding(val encoding: String) {
    @SerializedName("base64")
    BASE64("base64");
}
@Keep
data class DataSlice(
    @SerializedName("offset")
    val offset: Int,
    @SerializedName("length")
    val length: Int
)
