package com.particle.api.infrastructure.net.data

import androidx.annotation.Keep

@Keep
enum class EvmReqBodyMethod(var value: String) {
    particleSuggestedGasFees("particle_suggestedGasFees"),
    particleGetPrice("particle_getPrice"),
    particleGetTokensAndNFTs("particle_getTokensAndNFTs"),
    particleDeserializeTransaction("particle_deserializeTransaction"),
    particleGetTransactionsByAddress("particle_getTransactionsByAddress"),
    particleAbiEncodeFunctionCall("particle_abi_encodeFunctionCall"),
    particleGetTokensByTokenAddresses("particle_getTokensByTokenAddresses"),

    particleSwapGetQuote("particle_swap_getQuote"),
    particleSwapCheckApprove("particle_swap_checkApprove"),
    particleSwapGetSwap("particle_swap_getSwap"),

    particleSwapCreateOrder("particle_swap_createOrder"),
    particleSwapSubmitOrder("particle_swap_submitOrder"),


    web3ClientVersion("web3_clientVersion"),
    web3Sha3("web3_sha3"),
    netVersion("net_version"),

    ethProtocolVersion("eth_protocolVersion"),
    ethSyncing("eth_syncing"),
    ethMining("eth_mining"),
    ethGasPrice("eth_gasPrice"),
    ethAccounts("eth_accounts"),
    ethBlockNumber("eth_blockNumber"),
    ethGetBalance("eth_getBalance"),
    ethGetStorageAt("eth_getStorageAt"),
    ethGetTransactionCount("eth_getTransactionCount"),
    ethGetBlockTransactionCountByHash("eth_getBlockTransactionCountByHash"),
    ethGetBlockTransactionCountByNumber("eth_getBlockTransactionCountByNumber"),
    ethGetUncleCountByBlockHash("eth_getUncleCountByBlockHash"),
    ethGetUncleCountByBlockNumber("eth_getUncleCountByBlockNumber"),
    ethGetCode("eth_getCode"),
    ethCall("eth_call"),
    ethEstimateGas("eth_estimateGas"),
    ethGetBlockByHash("eth_getBlockByHash"),
    ethGetBlockByNumber("eth_getBlockByNumber"),
    ethGetTransactionByHash("eth_getTransactionByHash"),
    ethGetTransactionByBlockHashAndIndex("eth_getTransactionByBlockHashAndIndex"),
    ethGetTransactionByBlockNumberAndIndex("eth_getTransactionByBlockNumberAndIndex"),
    ethGetTransactionReceipt("eth_getTransactionReceipt"),
    ethGetUncleByBlockHashAndIndex("eth_getUncleByBlockHashAndIndex"),
    ethGetUncleByBlockNumberAndIndex("eth_getUncleByBlockNumberAndIndex"),
    ethGetLogs("eth_getLogs"),
    ethGetWork("eth_getWork"),
    ethSubmitWork("eth_submitWork"),
    ethSubmitHashrate("eth_submitHashrate"),
    particleBridgeGetTokens("particle_bridge_getTokens"),
    particleBridgeGetQuote("particle_bridge_getQuote"),
    particleBridgeCheckApprove("particle_bridge_checkApprove"),
    particleBridgeHistory("particle_bridge_history"),
    particleBridgeStatus("particle_bridge_status"),
    particleDidGetAddress("particle_did_getAddress"),
    particleDidGetDID("particle_did_getDID"),
}

@Keep
enum class AbiEncodeFunction(var value: String) {
    erc20Transfer("erc20_transfer"),
    erc20Approve("erc20_approve"),
    erc20TransferFrom("erc20_transferFrom"),
    erc721SafeTransferFrom("erc721_safeTransferFrom"),
    erc1155SafeTransferFrom("erc1155_safeTransferFrom"),
}
