package com.particle.api.infrastructure.net

import com.google.gson.JsonObject
import com.particle.api.infrastructure.net.data.ReqBody
import com.particle.api.infrastructure.net.data.RpcOutput
import com.particle.api.infrastructure.net.data.resp.*
import okhttp3.ResponseBody
import org.p2p.solanaj.model.types.*
import retrofit2.http.Body
import retrofit2.http.POST
import java.math.BigInteger


interface SolanaRpcApi {

    @POST("/solana")
    suspend fun rpc(@Body body: ReqBody): ResponseBody

    @POST("/solana")
    suspend fun enhancedGetPrice(@Body body: ReqBody): RpcOutput<List<RateResult>>

    @POST("/solana")
    suspend fun enhancedSerializeTransaction(@Body body: ReqBody): RpcOutput<SerializeTransResult>

    @POST("/solana")
    suspend fun enhancedGetTransactionsByAddress(@Body body: ReqBody): RpcOutput<List<TransResult>>

    @POST("/solana")
    suspend fun enhancedGetTokensAndNFTs(@Body body: ReqBody): RpcOutput<TokenResult>

    @POST("/solana")
    suspend fun enhancedGetTokensByTokenAddresses(@Body body: ReqBody): RpcOutput<List<CustomTokenResult>>

    @POST("/solana")
    suspend fun swapGetQuote(@Body body: ReqBody): RpcOutput<List<QuoteInfoSOL>>

    @POST("/solana")
    suspend fun swapGetQuoteJSONList(@Body body: ReqBody): RpcOutput<List<JsonObject>>

    @POST("/solana")
    suspend fun swapGetTransactions(@Body body: ReqBody): RpcOutput<List<QuoteTrans>>

    @POST("/solana")
    suspend fun getBalance(@Body body: ReqBody): RpcOutput<SOLBalanceInfo>

    @POST("/solana")
    suspend fun sendTransactions(@Body body: ReqBody): RpcOutput<String>

    @POST("/solana")
    suspend fun getTransaction(@Body body: ReqBody): RpcOutput<TransactionResp?>

    @POST("/solana")
    suspend fun getTransactionRespAny(@Body body: ReqBody): RpcOutput<Any?>

    @POST("/solana")
    suspend fun getAccountInfo(
        @Body body: ReqBody
    ): RpcOutput<AccountInfo?>

    @POST("/solana")
    suspend fun getFees(
        @Body rpcRequest: ReqBody
    ): RpcOutput<FeesResponse>

    @POST("/solana")
    suspend fun getMinimumBalanceForRentExemption(
        @Body rpcRequest: ReqBody
    ): RpcOutput<Long>

    @POST("/solana")
    suspend fun getTokenAccountsByOwner(
        @Body rpcRequest: ReqBody,
    ): RpcOutput<TokenAccounts>

    @POST("/solana")
    suspend fun getRecentBlockHash(
        @Body body: ReqBody
    ): RpcOutput<RecentBlockhash>

    @POST("/solana")
    suspend fun getBlockProduction(
        @Body body: ReqBody
    ): RpcOutput<BlockProductionResp>


    @POST("/solana")
    suspend fun rpcRespNullableAny(@Body body: ReqBody): RpcOutput<Any?>

    @POST("/solana")
    suspend fun rpcRespAny(@Body body: ReqBody): RpcOutput<Any>


    @POST("/solana")
    suspend fun rpcRespBigInteger(@Body body: ReqBody): RpcOutput<BigInteger>

    @POST("/solana")
    suspend fun rpcRespString(@Body body: ReqBody): RpcOutput<String>

    @POST("/solana")
    suspend fun rpcRespListString(@Body body: ReqBody): RpcOutput<List<String>>

    @POST("/solana")
    suspend fun rpcRespNullableBigInteger(@Body body: ReqBody): RpcOutput<BigInteger?>

    @POST("/solana")
    suspend fun getBlockCommitment(@Body body: ReqBody): RpcOutput<BlockCommitmentResp>

    @POST("/solana")
    suspend fun rpcRespListBigInteger(@Body body: ReqBody): RpcOutput<List<BigInteger>>

    @POST("/solana")
    suspend fun getClusterNodes(@Body body: ReqBody): RpcOutput<List<ClusterNodesResp>>

    @POST("/solana")
    suspend fun getEpochInfo(@Body body: ReqBody): RpcOutput<EpochInfoResp>

    @POST("/solana")
    suspend fun getEpochSchedule(@Body body: ReqBody): RpcOutput<EpochScheduleResp>

    @POST("/solana")
    suspend fun getFeeForMessage(@Body body: ReqBody): RpcOutput<List<Any>>

    @POST("/solana")
    suspend fun getHealth(@Body body: ReqBody): RpcOutput<HealthResp>

    @POST("/solana")
    suspend fun getHighestSnapshotSlot(@Body body: ReqBody): RpcOutput<HighestSnapshotSlotResp>

    @POST("/solana")
    suspend fun getIdentity(@Body body: ReqBody): RpcOutput<IdentityResp>

    @POST("/solana")
    suspend fun getInflationGovernor(@Body body: ReqBody): RpcOutput<InflationGovernorResp>

    @POST("/solana")
    suspend fun getInflationRate(@Body body: ReqBody): RpcOutput<InflationRateResp>

    @POST("/solana")
    suspend fun getInflationReward(@Body body: ReqBody): RpcOutput<List<Any>>

    @POST("/solana")
    suspend fun getLargestAccounts(@Body body: ReqBody): RpcOutput<LargestAccountsResp>

    @POST("/solana")
    suspend fun getLatestBlockhash(@Body body: ReqBody): RpcOutput<LatestBlockhashResp>

    @POST("/solana")
    suspend fun getRecentPerformanceSamples(@Body body: ReqBody): RpcOutput<List<PerformanceSampleResp>>

    @POST("/solana")
    suspend fun getSignaturesForAddress(@Body body: ReqBody): RpcOutput<List<SignaturesForAddressResp>>

    @POST("/solana")
    suspend fun getSignatureStatuses(@Body body: ReqBody): RpcOutput<SignatureStatusesResp?>

    @POST("/solana")
    suspend fun getStakeActivation(@Body body: ReqBody): RpcOutput<StakeActivationResp>

    @POST("/solana")
    suspend fun getStakeMinimumDelegation(@Body body: ReqBody): RpcOutput<StakeMinimumDelegationResp>

    @POST("/solana")
    suspend fun getSupply(@Body body: ReqBody): RpcOutput<SupplyResp>

    @POST("/solana")
    suspend fun getTokenAccountBalance(@Body body: ReqBody): RpcOutput<TokenAccountBalanceResp>

    @POST("/solana")
    suspend fun getTokenAccountsByDelegate(@Body body: ReqBody): RpcOutput<TokenAccountsByDelegateResp>

    @POST("/solana")
    suspend fun getTokenLargestAccounts(@Body body: ReqBody): RpcOutput<TokenLargestAccountsResp>

    @POST("/solana")
    suspend fun getTokenSupply(@Body body: ReqBody): RpcOutput<TokenSupplyResp>

    @POST("/solana")
    suspend fun getVersion(@Body body: ReqBody): RpcOutput<SolanaVersion>

    @POST("/solana")
    suspend fun getVoteAccounts(@Body body: ReqBody): RpcOutput<VoteAccountsResp>

    @POST("/solana")
    suspend fun isBlockhashValid(@Body body: ReqBody): RpcOutput<BlockhashResp>
}