package com.particle.api.infrastructure.net

import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.particle.api.infrastructure.net.data.ReqBody
import com.particle.api.infrastructure.net.data.RpcOutput
import com.particle.api.infrastructure.net.data.resp.*
import com.particle.base.model.PrefixedHexString
import okhttp3.ResponseBody
import retrofit2.http.Body
import retrofit2.http.POST


interface EvmRpcApi {

    @POST("/evm-chain")
    suspend fun rpc(@Body body: ReqBody): ResponseBody

    @POST("/evm-chain")
    suspend fun enhancedGetPrice(@Body body: ReqBody): RpcOutput<List<RateResult>>

    @POST("/evm-chain")
    suspend fun particleGetTransactionsByAddress(@Body body: ReqBody): RpcOutput<List<EvmTransResult>>

    @POST("/evm-chain")
    suspend fun particleGetTokensAndNFTs(@Body body: ReqBody): RpcOutput<TokenResult>

    @POST("/evm-chain")
    suspend fun particleSuggestedGasFees(@Body body: ReqBody): RpcOutput<EvmGasResult>

    @POST("/evm-chain")
    suspend fun particleAbiEncodeFunctionCall(@Body body: ReqBody): RpcOutput<String>

    @POST("/evm-chain")
    suspend fun particleGetTokensByTokenAddresses(@Body body: ReqBody): RpcOutput<List<CustomTokenResult>>

    @POST("/evm-chain")
    suspend fun ethCall(@Body body: ReqBody): RpcOutput<String>

    @POST("/evm-chain")
    suspend fun particleGetQuote(@Body body: ReqBody): RpcOutput<QuoteInfoEVM?>

    @POST("/evm-chain")
    suspend fun particleSwapCreateOrder(@Body body: ReqBody): RpcOutput<JsonObject>

    @POST("/evm-chain")
    suspend fun particleSwapSubmitOrder(@Body body: ReqBody): RpcOutput<JsonElement>

    @POST("/evm-chain")
    suspend fun particleSwapGetSwap(@Body body: ReqBody): RpcOutput<ParticleGetSwapResp?>

    @POST("/evm-chain")
    suspend fun particleGetBalance(@Body body: ReqBody): RpcOutput<PrefixedHexString>

    @POST("/evm-chain")
    suspend fun swapCheckApprove(@Body body: ReqBody): RpcOutput<ApprovedInfo>

    @POST("/evm-chain")
    suspend fun getTransactionReceipt(@Body body: ReqBody): RpcOutput<Any?>

    @POST("/evm-chain")
    suspend fun particleRespStringFunctionCall(@Body body: ReqBody): RpcOutput<String>

    @POST("/evm-chain")
    suspend fun particleRespHexStringFunctionCall(@Body body: ReqBody): RpcOutput<PrefixedHexString>

    @POST("/evm-chain")
    suspend fun particleRespBoolFunctionCall(@Body body: ReqBody): RpcOutput<Boolean>

    @POST("/evm-chain")
    suspend fun particleRespAnyFunctionCall(@Body body: ReqBody): RpcOutput<Any>


    @POST("/evm-chain")
    suspend fun particleRespListStringFunctionCall(@Body body: ReqBody): RpcOutput<List<String>>

    @POST("/evm-chain")
    suspend fun ethGetBlockByHash(@Body body: ReqBody): RpcOutput<BlockByHashInfo?>

    @POST("/evm-chain")
    suspend fun ethGetTransaction(@Body body: ReqBody): RpcOutput<TransactionByHashInfo?>

    @POST("/evm-chain")
    suspend fun ethCompileSolidity(@Body body: ReqBody): RpcOutput<CompileSolidityResp?>


    @POST("/evm-chain")
    suspend fun particleBridgeGetTokens(@Body body: ReqBody): RpcOutput<List<BridgeSupportedToken>>

    @POST("/evm-chain")
    suspend fun particleBridgeGetQuote(@Body body: ReqBody): RpcOutput<BridgeGetQuoteResp>

    @POST("/evm-chain")
    suspend fun particleBridgeCheckApprove(@Body body: ReqBody): RpcOutput<BridgeApproveResult>

    @POST("/evm-chain")
    suspend fun particleBridgeHistory(@Body body: ReqBody): RpcOutput<List<BridgeHistory>>

    @POST("/evm-chain")
    suspend fun particleBridgeStatus(@Body body: ReqBody): RpcOutput<JsonElement>

    @POST("/evm-chain")
    suspend fun particleDidGetAddress(@Body body: ReqBody): RpcOutput<String?>

    @POST("/evm-chain")
    suspend fun particleDidGetDID(@Body body: ReqBody): RpcOutput<List<String>>
}