package com.particle.api.infrastructure.db.table

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.ColumnInfo
import androidx.room.Entity
import com.particle.base.model.MobileWCWalletName
import kotlinx.android.parcel.Parcelize

@Keep
@Parcelize
@Entity(tableName = "wallet_info", primaryKeys = ["address", "walletName"])
data class WalletInfo(
    @ColumnInfo(name = "address") val address: String,
    @ColumnInfo(name = "walletName") var walletName: String,   //connect adapter name
    @ColumnInfo(name = "chainName") var chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,    //chain id long value
    @ColumnInfo(name = "name") var name: String?,
    @ColumnInfo(name = "isSelected", defaultValue = "0") var isSelected: Int,
    @ColumnInfo(name = "updateTime", defaultValue = "0") var updateTime: Long,
    @ColumnInfo(name = "sortKey", defaultValue = "0") var sortKey: Int,
    @ColumnInfo(name = "aaName", defaultValue = "Smart Account") var aaName: String? = "Smart Account",
) : Parcelable {
    companion object {

        fun createPnWallet(
            address: String,
            chainName: String,
            chainId: Long,
            isSelected: Int,
            name: String = "Particle Wallet",
        ): WalletInfo {
            return WalletInfo(
                address,
                MobileWCWalletName.Particle.name,
                chainName,
                chainId,
                name,
                isSelected,
                System.currentTimeMillis(),
                1
            )
        }


        fun createETHImportWallet(
            address: String,
            chainName: String,
            chainId: Long,
            isSelected: Int,
            name: String = "ETHImport",
            privateKey: String = "",
        ): WalletInfo {
            return WalletInfo(
                address,
                MobileWCWalletName.EVMConnect.name,
                chainName,
                chainId,
                name,
                isSelected,
                System.currentTimeMillis(),
                1
            )
        }

        fun createSOLImportWallet(
            address: String,
            chainName: String,
            chainId: Long,
            isSelected: Int,
            name: String = "SOLImport",
        ): WalletInfo {
            return WalletInfo(
                address,
                MobileWCWalletName.SolanaConnect.name,
                chainName,
                chainId,
                name,
                isSelected,
                System.currentTimeMillis(),
                1
            )
        }

        fun createWallet(
            address: String,
            chainName: String,
            chainId: Long,
            isSelected: Int,
            name: String,
            walletName: String,
        ): WalletInfo {
            return WalletInfo(
                address,
                walletName,
                chainName,
                chainId,
                name,
                isSelected,
                System.currentTimeMillis(),
                1
            )
        }
    }


    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as WalletInfo

        if (address != other.address) return false
        if (walletName != other.walletName) return false
        if (chainName != other.chainName) return false
        if (chainId != other.chainId) return false
        if (name != other.name) return false
        if (isSelected != other.isSelected) return false
        if (sortKey != other.sortKey) return false

        return true
    }

    //copy object
    fun copy(): WalletInfo {
        return WalletInfo(
            address,
            walletName,
            chainName,
            chainId,
            name,
            isSelected,
            updateTime,
            sortKey
        )
    }
}
